/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.ops;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.StoryModel;
import edu.mit.story.core.model.StoryModelExporter;
import edu.mit.story.core.model.StoryModelImporter;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.property.Configuration;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.core.util.XMLUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchModifyStoryOperation
extends WorkspaceModifyOperation {
    private final List<IFile> targets;
    private final IModelChange change;
    private final File outputDir;

    public BatchModifyStoryOperation(List<IFile> targets, IModelChange change, File outputFile) {
        if (targets.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (change == null) {
            throw new NullPointerException();
        }
        if (outputFile == null) {
            throw new NullPointerException();
        }
        this.targets = Collections.unmodifiableList(new ArrayList<IFile>(targets));
        this.change = change;
        this.outputDir = outputFile;
    }

    protected void execute(IProgressMonitor pm) throws CoreException, InvocationTargetException, InterruptedException {
        IFile[] files;
        pm.beginTask("Batch processing stories", this.targets.size());
        for (IFile target : this.targets) {
            try {
                pm.subTask(target.getName());
                this.process(target);
                pm.worked(1);
            }
            catch (Exception e) {
                String message = "A problem occured while processing the file: " + target.getName();
                StoryPlugin.getDefault().getLog().log((IStatus)new Status(4, "edu.mit.story.core", message, (Throwable)e));
                this.failWithMessage(message);
                e.printStackTrace();
            }
        }
        Path path = new Path(this.outputDir.getAbsolutePath());
        IFile[] iFileArray = files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            file.refreshLocal(2, pm);
            ++n2;
        }
        pm.done();
    }

    protected void failWithMessage(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Alignment Problem", (String)message);
            }
        });
    }

    protected void process(IFile target) throws IOException, CoreException {
        File output;
        String styExt = "sty";
        String filename = target.getName();
        if (!filename.endsWith(styExt)) {
            filename = filename.substring(0, filename.length() - target.getFileExtension().length());
            filename = String.valueOf(filename) + styExt;
        }
        if ((output = new File(this.outputDir, filename)).exists()) {
            throw new IllegalStateException("The file exists");
        }
        IMutableStoryModel model = "sty".equalsIgnoreCase(target.getFileExtension()) ? StoryModelImporter.extractModel((IFile)target, null) : this.createNewModel(target);
        this.change.apply((Object)this, model);
        Document xml = StoryModelExporter.getInstance().exportToXML((IStoryModel)model);
        String content = XMLUtils.toString((Document)xml);
        output.createNewFile();
        FileWriter writer = new FileWriter(output);
        writer.write(content);
        writer.close();
    }

    protected IMutableStoryModel createNewModel(IFile target) throws CoreException {
        BufferedInputStream is = new BufferedInputStream(target.getContents());
        StringBuilder sb = new StringBuilder();
        StringUtils.loadStreamIntoBuffer((Appendable)sb, (InputStream)is);
        int idx = sb.length() - 1;
        while (Character.isWhitespace(sb.charAt(idx))) {
            sb.deleteCharAt(idx--);
        }
        if (sb.charAt(idx) == '-') {
            sb.deleteCharAt(idx--);
        }
        while (Character.isWhitespace(sb.charAt(idx))) {
            sb.deleteCharAt(idx--);
        }
        while (Character.isDigit(sb.charAt(idx))) {
            sb.deleteCharAt(idx--);
        }
        while (Character.isWhitespace(sb.charAt(idx))) {
            sb.deleteCharAt(idx--);
        }
        sb.append('\n');
        String noCRLFs = Pattern.compile("\\Q\r\n\\E").matcher(sb.toString()).replaceAll("\n");
        String noCRs = Pattern.compile("\\Q\r\\E").matcher(noCRLFs).replaceAll("\n");
        StoryModel model = new StoryModel(CharRep.getInstance());
        Configuration charRepConfig = new Configuration(CharRep.getInstance().getConfigurationDescriptor());
        charRepConfig.put((Object)"editable", (Object)Boolean.FALSE.toString());
        model.getData().setConfiguration((IConfiguration)charRepConfig);
        SimplePosition p = new SimplePosition(0, noCRs.length());
        IData charData = CharRep.getInstance().reconstitute((IHasPosition)p, noCRs.toString(), null);
        Desc charDesc = new Desc(0L, CharRep.getInstance(), (IHasPosition)p, charData, null);
        Timing creationTime = new Timing("generation_wizard", true);
        charDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)charDesc, (IMetaData)creationTime));
        charDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)charDesc, (IMetaData)new Origin("generation_wizard")));
        model.getData().add((Object)charDesc);
        return model;
    }
}

