/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.notify.INotifyMapCallback;
import edu.mit.story.core.notify.NotifyingSortedMap;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepUtils;
import edu.mit.story.core.util.SortedKeySet;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.model.IRepSelectionModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepSelectionModel
extends AbstractViewModel
implements IRepSelectionModel {
    protected final Predicate<IRep> isSelected = new Predicate<IRep>(){

        public boolean apply(IRep input) {
            return RepSelectionModel.this.isSelected(input);
        }
    };
    protected final Predicate<IRep> isRequired = new Predicate<IRep>(){

        public boolean apply(IRep input) {
            return RepSelectionModel.this.isRequired(input);
        }
    };
    protected final Predicate<IRep> isIncluded = new Predicate<IRep>(){

        public boolean apply(IRep input) {
            return RepSelectionModel.this.isIncluded(input);
        }
    };
    protected final SortedMap<IRep, State> reps = new NotifyingSortedMap((INotifyMapCallback)new INotifyMapCallback<IRep, State>(){

        public void mappingAdded(IRep key, State value) {
            RepSelectionModel.this.fireChanged();
        }

        public void mappingModified(IRep key, State newValue, State oldValue) {
            RepSelectionModel.this.fireChanged();
        }

        public void mappingRemoved(IRep key, State value) {
            RepSelectionModel.this.fireChanged();
        }
    });
    protected final SortedSet<IRep> supportedSet = new SortedKeySet<IRep, State>(this.reps){

        public boolean add(IRep o) {
            if (this.getBackingMap().containsKey(o)) {
                return false;
            }
            this.getBackingMap().put(o, new State(false, false));
            return true;
        }
    };
    protected final Set<IRep> selectedSet = Collections.unmodifiableSet(Sets.filter(this.reps.keySet(), this.isSelected));
    protected final Set<IRep> requiredSet = Collections.unmodifiableSet(Sets.filter(this.reps.keySet(), this.isRequired));
    protected final Set<IRep> includedSet = Collections.unmodifiableSet(Sets.filter(this.reps.keySet(), this.isIncluded));

    @Override
    public SortedSet<IRep> getSupported() {
        return this.supportedSet;
    }

    @Override
    public Set<IRep> getSelected() {
        return this.selectedSet;
    }

    @Override
    public Set<IRep> getRequired() {
        return this.requiredSet;
    }

    @Override
    public Set<IRep> getIncluded() {
        return this.includedSet;
    }

    @Override
    public boolean isSupported(IRep rep) {
        return this.reps.containsKey(rep);
    }

    @Override
    public boolean isSelected(IRep rep) {
        State state = (State)this.reps.get(rep);
        if (state == null) {
            return false;
        }
        return state.isSelected();
    }

    @Override
    public boolean isIncluded(IRep rep) {
        State state = (State)this.reps.get(rep);
        if (state == null) {
            return false;
        }
        return state.isIncluded();
    }

    @Override
    public boolean isRequired(IRep rep) {
        State state = (State)this.reps.get(rep);
        if (state == null) {
            return false;
        }
        return state.isRequired();
    }

    @Override
    public void setSelected(IRep rep, boolean isSelected) {
        State state = (State)this.reps.get(rep);
        if (state == null) {
            this.reps.put(rep, new State(isSelected, false));
        } else {
            state.setSelected(isSelected);
        }
    }

    @Override
    public void setRequired(IRep rep, boolean isRequired) {
        State state = (State)this.reps.get(rep);
        if (state == null) {
            this.reps.put(rep, new State(false, isRequired));
        } else {
            state.setRequired(isRequired);
        }
    }

    public boolean isCleared() {
        return this.reps.isEmpty();
    }

    protected void internalClear() {
        this.reps.clear();
    }

    protected IMessageProvider calculateMessage() {
        return Message.NO_MESSAGE;
    }

    public static IRepSelectionModel makeConsistentModel(Set<IRep> available, Set<IRep> required, Set<IRep> selected) {
        if (available == null) {
            available = new HashSet<IRep>();
        }
        if (required == null) {
            available = new HashSet<IRep>();
        }
        if (selected == null) {
            available = new HashSet<IRep>();
        }
        IRepSet avl = RepUtils.closeWithAntecedents(available);
        IRepSet sel = RepUtils.closeWithAntecedents(selected);
        IRepSet req = RepUtils.closeWithAntecedents(required);
        sel.addAll((Collection)req);
        avl.addAll((Collection)sel);
        RepSelectionModel model = new RepSelectionModel();
        model.getSupported().addAll((Collection<IRep>)avl);
        model.getSelected().addAll((Collection<IRep>)sel);
        model.getRequired().addAll((Collection<IRep>)req);
        return model;
    }

    public static void checkConsistency(IRepSelectionModel model) {
        IRepSet expected = RepUtils.closeWithAntecedents(model.getSupported());
        if (!expected.equals(model.getSupported())) {
            throw new IllegalArgumentException();
        }
        expected = RepUtils.closeWithAntecedents(model.getSelected());
        if (!expected.equals(model.getSelected())) {
            throw new IllegalArgumentException();
        }
        expected = RepUtils.closeWithAntecedents(model.getRequired());
        if (!expected.equals(model.getRequired())) {
            throw new IllegalArgumentException();
        }
    }

    protected class State {
        private boolean isRequired;
        private boolean isSelected;

        public State() {
            this(false, false);
        }

        public State(boolean isSelected, boolean isRequired) {
            this.isSelected = isSelected;
            this.isRequired = isRequired;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public boolean isIncluded() {
            return this.isSelected || this.isRequired;
        }

        public void setSelected(boolean newValue) {
            if (this.isSelected == newValue) {
                return;
            }
            this.isSelected = newValue;
            RepSelectionModel.this.fireChanged();
        }

        public void setRequired(boolean newValue) {
            if (this.isRequired == newValue) {
                return;
            }
            this.isRequired = newValue;
            RepSelectionModel.this.fireChanged();
        }
    }
}

