/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.actions.delegates;

import edu.mit.parsing.core.rep.pos.AssignPOSChange;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.parsing.ui.dialogs.POSTagChooserDialog;
import edu.mit.parsing.ui.dialogs.WordSelectionDialog;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.ui.actions.delegates.AbstractDelegate;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.editor.StoryEditorUtils;
import java.util.Date;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class AssignPOSDelegate
extends AbstractDelegate {
    IStoryEditor editor;

    public void setActivePart(IWorkbenchPart activePart) {
        this.editor = StoryEditorUtils.extractStoryEditor((IWorkbenchPart)activePart);
    }

    public void updateAction(IAction action) {
        boolean enabled = this.editor != null && this.editor.getStoryModel().supports(POSRep.getInstance());
        action.setEnabled(enabled);
    }

    public void run(IAction action) {
        Date start = new Date();
        IDescSet tokens = ParsingUtils.getSelectedTokens((IStoryEditor)this.editor);
        if (tokens.isEmpty()) {
            PlatformUI.getWorkbench().getDisplay().beep();
            return;
        }
        IDesc word = WordSelectionDialog.open(this.editor);
        if (word == null) {
            return;
        }
        IDescSet ds = this.editor.getStoryModel().getData().getDescriptions(POSRep.getInstance()).matchSet((IHasPosition)word);
        IPosTag selTag = null;
        for (IDesc d : ds) {
            IPosTag tag = (IPosTag)d.getData();
            if (tag.getWord().getID() != word.getID()) continue;
            if (selTag != null) {
                selTag = null;
                break;
            }
            selTag = tag;
        }
        IPosData newTag = POSTagChooserDialog.open(this.editor.getSite().getShell(), POSTagChooserDialog.Filter.TOKENS, selTag);
        if (newTag == null) {
            return;
        }
        this.editor.getStoryModel().applyChange((Object)this, (IModelChange)new AssignPOSChange(newTag, word, (ITiming)new Timing(start, ((Object)((Object)this)).getClass().getCanonicalName())), false);
    }
}

