/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.actions;

import edu.mit.parsing.core.rep.tag.ITagData;
import edu.mit.parsing.core.rep.tag.TagData;
import edu.mit.parsing.core.rep.tag.TagRep;
import edu.mit.parsing.core.rep.tag.tagset.ITag;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.ActionGroup;

public class ChangeTagDataFeatureActionGroup
extends ActionGroup {
    private final IStoryEditor editor;
    private final ISelectionProvider provider;

    public ChangeTagDataFeatureActionGroup(IStoryEditor editor, ISelectionProvider provider) {
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.provider = provider;
    }

    protected IRep getRep() {
        return TagRep.getInstance();
    }

    protected MenuManager createActions(final IStoryEditor editor, final ISelectionProvider provider) {
        final ITagset tagset = TagRep.getTagset((IStoryModel)editor.getStoryModel());
        MenuManager tagMenu = new MenuManager("&Tag");
        tagMenu.setRemoveAllWhenShown(true);
        tagMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (ITag t : tagset) {
                    manager.add((IAction)new ChangeTagAction(t, editor, provider));
                }
            }
        });
        return tagMenu;
    }

    protected static String extractName(Object obj) {
        StringBuilder sb = new StringBuilder();
        if (obj instanceof IHasName) {
            sb.append(((IHasName)obj).getName());
        } else {
            sb.append(obj.toString());
        }
        sb.insert(0, '&');
        return sb.toString();
    }

    public void fillContextMenu(IMenuManager menu) {
        Object element = SelectionUtils.extractSingle((ISelection)this.getContext().getSelection(), Object.class);
        Object obj = element;
        if (obj instanceof IDesc) {
            IDesc d = (IDesc)obj;
            if (this.getRep().isType((IHasRep)d)) {
                obj = d.getData();
            }
        }
        StoryEditorContentProvider.Element child = null;
        if (obj instanceof StoryEditorContentProvider.Element) {
            child = (StoryEditorContentProvider.Element)obj;
            obj = child.getElement();
        }
        if (obj instanceof ITagData) {
            MenuManager tagMenu = this.createActions(this.editor, this.provider);
            menu.appendToGroup("additions", (IContributionItem)tagMenu);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeTagAction
    extends ChangeTagDataFeatureAction<ITag> {
        public ChangeTagAction(ITag feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(ITagData t) {
            return ((ITag)this.getFeature()).getID().equals(t.getTagID());
        }

        @Override
        protected ITagData create(ITagData old) {
            return new TagData(((ITag)this.getFeature()).getID(), (Collection)old);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ChangeTagDataFeatureAction<F>
    extends Action {
        private F feature;
        private IStoryEditor editor;
        private ISelectionProvider provider;

        public ChangeTagDataFeatureAction(F feature, IStoryEditor editor, ISelectionProvider provider) {
            super(ChangeTagDataFeatureActionGroup.extractName(feature), 2);
            if (feature == null) {
                throw new NullPointerException();
            }
            if (editor == null) {
                throw new NullPointerException();
            }
            if (provider == null) {
                throw new NullPointerException();
            }
            this.feature = feature;
            this.editor = editor;
            this.provider = provider;
        }

        public F getFeature() {
            return this.feature;
        }

        protected IDesc getTargetDesc() {
            Object element = SelectionUtils.extractSingle((ISelection)this.provider.getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                if (ChangeTagDataFeatureActionGroup.this.getRep().isType((IHasRep)d)) {
                    return d;
                }
            }
            return null;
        }

        public boolean isChecked() {
            Object element = SelectionUtils.extractSingle((ISelection)this.provider.getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                element = d.getData();
            }
            if (element instanceof ITagData) {
                return this.isChecked((ITagData)element);
            }
            return false;
        }

        protected abstract boolean isChecked(ITagData var1);

        public void run() {
            IDesc oldDesc = this.getTargetDesc();
            if (oldDesc == null) {
                throw new IllegalStateException("no description on which to work");
            }
            ITagData newData = this.create((ITagData)oldDesc.getData());
            Desc newDesc = new Desc(oldDesc.getID(), oldDesc.getRep(), newData.calculatePosition(), (IData)newData, null);
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)Origin.USER_SPECIFIED));
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)new Timing(((Object)((Object)this)).getClass().getCanonicalName(), true)));
            RemoveDescriptionsChange change = new RemoveDescriptionsChange(oldDesc);
            change = new CompositeModelChange(new IModelChange[]{change, new AddDescriptionsChange((IDesc)newDesc)});
            this.editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        }

        protected abstract ITagData create(ITagData var1);
    }
}

