/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.widgets;

import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.discourse.ui.content.RelPropContentProvider;
import edu.mit.discourse.ui.label.RelPropLabelProvider;
import edu.mit.discourse.ui.relprops.IRelPropManager;
import edu.mit.story.core.util.XMLUtils;
import edu.mit.story.ui.content.IHasTreeViewer;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.w3c.dom.Document;

public class RelPropViewer
extends Composite
implements IHasTreeViewer {
    private TreeViewer viewer;

    public RelPropViewer(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.createContents(this);
    }

    protected void createContents(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Relation Properties");
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.viewer = this.createTreeViewer(parent);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new RelPropContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RelPropLabelProvider());
        this.viewer.setInput((Object)DiscourseUIPlugin.getDefault().getRelPropManager());
        Composite buttonPanel = new Composite(parent, 0);
        buttonPanel.setLayoutData((Object)new GridData(4, 4, false, true));
        GridLayout layout = new GridLayout();
        buttonPanel.setLayout((Layout)layout);
        this.createButtons(buttonPanel);
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer result = new TreeViewer(parent, 2816);
        Tree tree = result.getTree();
        tree.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        TreeColumn tc = new TreeColumn(tree, 0);
        tc.setText("value");
        tc.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(4));
        tc = new TreeColumn(tree, 0);
        tc.setText("id");
        tc.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3));
        tc = new TreeColumn(tree, 0);
        tc.setText("auto");
        tc.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        tc = new TreeColumn(tree, 0);
        tc.setText("drop");
        tc.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        tc = new TreeColumn(tree, 0);
        tc.setText("mirror of");
        tc.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3));
        tc = new TreeColumn(tree, 0);
        tc.setText("prefixes");
        tc.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        tc = new TreeColumn(tree, 0);
        tc.setText("description");
        tc.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(4));
        return result;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    protected void createButtons(Composite parent) {
        Button importButton = new Button(parent, 128);
        importButton.setText("&Import");
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelPropViewer.this.doImport();
            }
        });
        Button exportButton = new Button(parent, 128);
        exportButton.setText("&Export");
        exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelPropViewer.this.doExport();
            }
        });
    }

    protected void doImport() {
        FileDialog chooser = new FileDialog(this.getShell(), 4096);
        chooser.setText("Import Property Set");
        chooser.setFilterExtensions(new String[]{"*.xml"});
        String path = chooser.open();
        if (path == null) {
            return;
        }
        Document doc = null;
        try {
            FileReader reader = new FileReader(path);
            doc = XMLUtils.fromString((Reader)reader);
        }
        catch (Exception e) {
            Status status = new Status(4, DiscourseUIPlugin.getDefault().getID(), e.getLocalizedMessage(), (Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error Importing File", (String)"There was a problem opening the property file", (IStatus)status);
            return;
        }
        if (doc == null) {
            Status status = new Status(4, DiscourseUIPlugin.getDefault().getID(), "Unable to create valid XML document from file");
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error Importing File", (String)"There was a problem parsing the property file", (IStatus)status);
            return;
        }
        try {
            IRelPropManager m = DiscourseUIPlugin.getDefault().getRelPropManager();
            if (m.load(doc)) {
                this.viewer.refresh();
            }
        }
        catch (Exception e) {
            Status status = new Status(4, DiscourseUIPlugin.getDefault().getID(), e.getLocalizedMessage(), (Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error Importing File", (String)"There was a problem validating the property file", (IStatus)status);
            return;
        }
    }

    protected void doExport() {
        FileDialog chooser = new FileDialog(this.getShell(), 8192);
        chooser.setText("Export Property Set");
        chooser.setFileName("relprops.xml");
        chooser.setFilterExtensions(new String[]{"*.xml"});
        String path = chooser.open();
        if (path == null) {
            return;
        }
        if (!path.endsWith(".xml")) {
            path = String.valueOf(path) + ".xml";
        }
        try {
            Document doc = DiscourseUIPlugin.getDefault().getRelPropManager().export();
            FileWriter writer = new FileWriter(path);
            writer.append(XMLUtils.toString((Document)doc));
            writer.close();
        }
        catch (Exception e) {
            Status status = new Status(4, DiscourseUIPlugin.getDefault().getID(), e.getLocalizedMessage(), (Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error Exporting File", (String)"There was a problem writing the property file", (IStatus)status);
            return;
        }
    }
}

