/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.actions;

import edu.mit.discourse.core.rep.referent.Referent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.core.rep.referent.change.RenameReferentChange;
import edu.mit.discourse.ui.DiscourseUIMessages;
import edu.mit.discourse.ui.dialogs.RenameValidator;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.actions.DescActionUtils;
import edu.mit.story.ui.actions.generic.RenameAction;
import edu.mit.story.ui.editor.IHasStoryEditor;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Date;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.PlatformUI;

public class RenameReferent
extends RenameAction
implements IHasStoryEditor,
ISelectionChangedListener {
    IStoryEditor editor;
    ISelectionProvider provider;
    IDesc currentSelection;

    public RenameReferent(IStoryEditor editor, ISelectionProvider entitySelectionProvider) {
        if (editor == null || entitySelectionProvider == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.provider = entitySelectionProvider;
        entitySelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void doRename() {
        if (this.currentSelection == null) {
            return;
        }
        Date start = new Date();
        Referent entity = (Referent)this.currentSelection.getData();
        InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), DiscourseUIMessages.DIALOG_RenameReferent_Title, DiscourseUIMessages.DIALOG_RenameReferent_Prompt, entity.getName(), (IInputValidator)new RenameValidator(entity.getName()));
        int dialogResult = dialog.open();
        if (dialogResult != 0) {
            return;
        }
        String newName = dialog.getValue();
        if (entity.getName().equals(newName)) {
            return;
        }
        Timing timing = new Timing(start, "user");
        this.editor.getStoryModel().applyChange((Object)this, (IModelChange)new RenameReferentChange(newName, this.currentSelection, (ITiming)timing), false);
    }

    public void setStoryEditor(IStoryEditor newEditor) {
        this.editor = newEditor;
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.provider != null) {
            this.currentSelection = DescActionUtils.extractSingle((ISelection)this.provider.getSelection(), (IRep)ReferentRep.getInstance());
            this.setEnabled(this.currentSelection != null);
        } else {
            this.setEnabled(false);
        }
    }
}

