/* Filename: PropertyType.java
 * Creator: markaf
 * Format: Java 2 v1.6.0
 * Date created: Aug 27, 2010
 */
package edu.mit.discourse.core.rep.refprops;

import edu.mit.story.core.descriptor.IHasDescription;
import edu.mit.story.core.descriptor.IHasName;

/** 
 * TODO: Write comment
 *
 * @author markaf
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public enum PropertyType implements IHasName, IHasDescription {
	DESCRIPTIVE     ("Descriptive",       "Generally descriptive that does not fall into another property category"),
	CLASS           ("Class",             "Indicates the referent is a member of this class; if the marked property could also be a name or title, choose this category"),
	PHYSICAL        ("Physical Property", "Physical property such as height, weight, shape, color, or size"),
	PERSONALITY     ("Personality Trait", "Personality trait such as 'heroic' or 'cowardly'"),
	NAME_OR_TITLE   ("Name/Title",        "A name or title that is not a Type, such as 'Mr.' or 'Miss'"),
	ORDINAL         ("Ordinal",           "An indication of position in an order, such as 'first', 'second', 'first', 'last', 'next'"),
	AMOUNT_COUNTABLE("Countable Amount",  "An amount indicated by a specific count, such as 'five' or 'two thousand'"),
	AMOUNT_MASS     ("Mass Amount",       "An amount measured in mass terms, such as 'two pounds' or 'five liters'"),
	QUANTIFICATION  ("Quantification",    "A quantification of amount that is neither mass nor countable, such as 'all', 'every', or 'some'"),
	ORIGIN          ("Origin",            "Where the referent came from, or the place with which it is associated, such as 'russian' in 'russian bone' or 'cockroach' in 'cockroach milk'"),
	LOCATION        ("Location",          "Where the referent is located or positioned, such as 'front' in 'front teeth' or 'upper' in 'upper room'"),
	MATERIAL        ("Material",          "The substance out of which the referent is made"),
	WHOLE           ("Whole",             "A larger object of which the referent is but a part; if the property could also be an origin, choose this category"),
	UNKNOWN         ("Unknown",           "A property of unknown type");
	
	private final String name;
	private final String desc;

	/**
	 * TODO: Write comment
	 *
	 * @param name
	 * @param desc
	 * @since edu.mit.discourse.core 1.0.0
	 */
	private PropertyType(String name, String desc) {
		if(name.trim().length() == 0)
			throw new IllegalArgumentException();
		if(desc.trim().length() == 0)
			throw new IllegalArgumentException();
		this.name = name;
		this.desc = desc;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.descriptor.IHasName#getName()
	 */
	public String getName() {
		return name;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.descriptor.IHasDescription#getDescription()
	 */
	public String getDescription() {
		return desc;
	}

}
