/* Filename: ReferenceModel.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Sep 8, 2009
 */
package edu.mit.discourse.core.rep.referent.model;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.parsing.core.model.SegmentSetModel;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.model.IStoryModel;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.ui 1.0.0
 */
public class ReferenceModel extends SegmentSetModel implements IReferenceModel {
	
	private IReferentModel parent;
	private IReference loaded;
	
	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @param storyModel
	 * @since edu.mit.discourse.ui 1.0.0
	 */
	public ReferenceModel(IStoryModel storyModel) {
		super(TokenRep.getInstance(), storyModel);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.referent.IReference#getID()
	 */
	
	public int getID() {
		if(loaded != null) return loaded.getID();
		if(parent != null) return parent.getID(this);
		return -1;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.ui.models.IReferenceModel#getReferent()
	 */
	
	public IReferent getParent() {
		return loaded == null ? parent : loaded.getParent();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.ui.models.IReferenceModel#setReferent(edu.mit.discourse.ui.models.IReferentModel)
	 */
	
	public void setParent(IReferentModel parent) {
		this.parent = parent;
		setOutOfSync();
		notifyChangeListeners();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.ui.models.IReferenceModel#getLoaded()
	 */
	
	public IReference getLoaded() {
		return loaded;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.ui.models.IReferenceModel#load(edu.mit.discourse.core.rep.referent.IReference)
	 */
	
	public void load(IReference ref) {
		internalClear();
		this.loaded = ref;
		setSegments(ref.getSegments());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.parsing.ui.models.SegmentSetModel#clear()
	 */
	@Override
	protected void internalClear() {
		this.loaded = null;
		super.internalClear();
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IData#equals(edu.mit.story.core.desc.IData, edu.mit.story.core.align.IAlignedStoryModel)
	 */
	public boolean equals(IData tgtData, IAlignedStoryModel model) {
		throw new UnsupportedOperationException();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.referent.IReference#getExpression()
	 */
	public ISegmentSet getExpression() {
		return new SegmentSet(getSegments());
	}

}
