/* Filename: DiscourseRelationRep.java
 * Author: Mark A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Oct 16, 2007
 */
package edu.mit.discourse.core.rep.referent;

import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;


/** 
 * A representation of discourse relationships within a text. 
 *
 * @author Mark A. Finlayson
 * @version 1.00, (Oct 16, 2007)
 * @since 1.5.0
 */
public class ReferentRep extends AbstractRep {
	
	/** 
	 * The default identifier for the Referent representation, which is {@value}
	 *
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public static final String ID = "edu.mit.discourse.referent";
	
	private static final long serialVersionUID = 1L;
	
	private static IRep fInstance = null;
	
	public static IRep getInstance(){
		if(fInstance == null) fInstance = StoryPlugin.getDefault().getRepManager().getRep(ID);
		return fInstance;
	}

	public ReferentRep() {
		super(IReferent.class, 1);
	}

	/* (non-Javadoc) @see edu.mit.story.core.rep.AbstractRepresentation#initAntecedentsInternal(edu.mit.story.core.rep.IRepresentationSet) */
	@Override
	protected void initAntecedentsInternal(IRepSet container) {
		container.add(TokenRep.getInstance());
	}

	/* (non-Javadoc) @see edu.mit.story.core.rep.IRepresentation#serialize(java.lang.Object) */
	public String serialize(IData data) {
		IReferent referent = (IReferent)data;
		return Referent.serialize(referent);
	}

	/* (non-Javadoc) @see edu.mit.story.core.rep.IRepresentation#reconstitute(java.lang.String) */
	public Referent reconstitute(IHasPosition p, String description, IStoryModel provider) {
		return Referent.reconstitute(description, provider.getData());
	}
	
}
