/* Filename: RefExpTranslationFactory.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: May 7, 2010
 */
package edu.mit.discourse.core.rep.coref;

import java.util.LinkedList;
import java.util.List;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public class CorefTranslationFactory extends AbstractDescFactory2<IndexedCoref> {
	
	public static final String ID = "edu.mit.discourse.rep.coref.factory.translation";

	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @param requiredRep
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public CorefTranslationFactory() {
		super(CorefRep.getInstance(), ReferentRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.factory.AbstractDescFactory2#calculateRegions(edu.mit.story.core.model.change.StoryChangeEvent)
	 */
	@Override
	protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
		// this factory is not intended to generate any data
		return null;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.factory.AbstractDescFactory2#calculateData(edu.mit.story.core.position.IHasPosition, edu.mit.story.core.model.IStoryModel)
	 */
	@Override
	protected IHasPositionSet<IndexedCoref> calculateData(IHasPosition region, IStoryModel model) {
		
		if(!model.supports(ReferentRep.getInstance()))
			return null;
		
		// collect all coreferences in region
		IDescSet refDescs = model.getData().getDescriptions(ReferentRep.getInstance()).openSet(region);
		IHasPositionSet<IReferent> refs = new HasPositionSet<IReferent>();
		for(IDesc refDesc : refDescs)
			refs.add((IReferent)refDesc.getData());

		if(refs.isEmpty())
			return null;
		
		// translate into corefs
		IHasPositionSet<IndexedCoref> result = new HasPositionSet<IndexedCoref>();
		ICoref coref;
		
		IDescSet refexpDescs = model.getData().getDescriptions(RefExpRep.getInstance()).openSet(region);
		
		List<IDesc> refexps = new LinkedList<IDesc>();
		IDesc refexpDesc;
		for(IReferent ref : refs){
			refexps.clear();
			for(IReference r : ref.getReferences()){
				refexpDesc = getReferringExpression(r, refexpDescs);
				if(refexpDesc != null)
					refexps.add(refexpDesc);
			}
			coref = new Coref(ref.getName(), refexps);
			result.add(new IndexedCoref(coref));
		}
		return result;
	}
	
	/**
	 * TODO: Write comment
	 *
	 * @param r
	 * @param refexps
	 * @return
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public static IDesc getReferringExpression(IReference r, IDescSet refexps){
		
		IRefExp refexp;
		IDescSet oldDescs, newDescs;
		for(IDesc d : refexps){
			refexp = (IRefExp)d.getData();
			oldDescs = Segment.extractSegmentDescriptions(r);
			newDescs = Segment.extractSegmentDescriptions(refexp);
			if(oldDescs.equals(newDescs))
				return d;
		}
		return null;
	}
	
}
