/* Filename: DiscourseRelationRep.java
 * Author: Mark A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Oct 16, 2007
 */
package edu.mit.discourse.core.rep.coref;

import java.util.Arrays;
import java.util.List;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.mappers.DescriptionMapper;
import edu.mit.story.core.mappers.IValueMapper;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;


/** 
 * Referential expressions 
 *
 * @author Mark A. Finlayson
 * @version 1.00, (Oct 16, 2007)
 * @since 1.5.0
 */
public class CorefRep extends AbstractRep {
	
	public static final String ID = "edu.mit.discourse.rep.coref";
	
	private static final long serialVersionUID = 1L;
	
	private static IRep instance = null;
	
	/**
	 * TODO: Write comment
	 *
	 * @return
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public static IRep getInstance(){
		if(instance == null) 
			instance = StoryPlugin.getDefault().getRepManager().getRep(ID);
		return instance;
	}

	/**
	 * TODO: Write comment
	 *
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public CorefRep() {
		super(ICoref.class, 1);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.AbstractRep#initAntecedentsInternal(edu.mit.story.core.rep.IRepSet)
	 */
	@Override
	protected void initAntecedentsInternal(IRepSet container) {
		container.add(RefExpRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IRep#serialize(java.lang.Object)
	 */
	public String serialize(IData data) {
		ICoref coref = (ICoref)data;
		String name = coref.getName();
		String descs = DescriptionMapper.toValueStatic(coref.getReferentialExpressions());
		return BlockMapper.PIPE.serialize(Arrays.asList(name, descs));
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IRep#reconstitute(edu.mit.story.core.position.IHasPosition, java.lang.String, edu.mit.story.core.model.IStoryModel)
	 */
	public Coref reconstitute(IHasPosition p, String data, IStoryModel model) {
		List<String> fields = BlockMapper.PIPE.reconstitute(data);
		if(fields.size() != 2)
			throw new IllegalArgumentException();
		
		// name field
		String name = fields.get(0);
		
		// desc field
		IValueMapper<IDesc> mapper = new DescriptionMapper(model.getData());
		List<IDesc> descs = mapper.reconstitute(fields.get(1));
		
		// make object
		return new Coref(name, descs);
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.AbstractRep#getBatchModelChange()
	 */
	@Override
	public IModelChange getBatchModelChange() {
		return new GenerateRefexpCorefModelChange();
	}
	
	public static IDesc findParent(IRefExp refexp, IStoryModel model){
		return findParent(refexp, model.getData().getDescriptions(getInstance()));
	}
	
	public static IDesc findParent(IRefExp refexp, IDescSet corefDescs){
		corefDescs = corefDescs.closedSet(refexp);
		ICoref coref;
		for(IDesc corefDesc : corefDescs){
			coref = (ICoref)corefDesc.getData();
			for(IDesc refexpDesc : coref.getReferentialExpressions())
				if(refexpDesc.getData() == refexp)
					return corefDesc;
		}
		return null;
	}
	
}
