/* Filename: AbstractScored.java
 * Author: Andrew B. Shapiro
 * Format: Java 2 v1.5.0
 * Date created: Aug 9, 2008
 */
package edu.mit.discourse.core.compare;

/**
 * <code>AbstractScored</code> wraps a protected double as to give a static backing to the
 * <code>IScored</code> interface.
 * 
 * @author Andrew B. Shapiro
 * @since 1.5.0 (Aug 9, 2008)
 */
public abstract class AbstractScored {
	protected double score;

	public double getScore() {
		return this.score;
	}

	/**
	 * Sets the new value to be return by <code>getScore()</code>. This method is protected.
	 * @param score the new value to be returned by <code>getScore()</code>
	 */
	protected void setScore(double score) {
		this.score = score;
	}
}
