/* Filename: DiscoursePlugin.java
 * Author: M. A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Dec 6, 2007
 */
package edu.mit.discourse.core;

import edu.mit.story.core.IdentifiedPlugin;

/** One line description goes here...
 * More detail goes here...
 *
 * @author M.A. Finlayson
 * @since 1.5.0
 */
public class DiscoursePlugin extends IdentifiedPlugin {
	
	/** 
	 * The default identifier for this plugin, which is {@value}
	 *
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public static final String ID = "edu.mit.discourse.core";

	private static DiscoursePlugin instance;

	/** Returns the singleton instance */
    public static DiscoursePlugin getDefault() {
        return instance;
    }

    public DiscoursePlugin() {
    	if(instance != null) throw new IllegalStateException();
		instance = this;
	}

}
