/* Filename: DiscourseMessages.java
 * Author: Mark A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Oct 11, 2007
 */
package edu.mit.discourse.core;

import java.util.ResourceBundle;

import org.eclipse.osgi.util.NLS;


/** One line description goes here...
 * More detail goes here...
 *
 * @author Mark A. Finlayson
 * @version 1.00, (Oct 11, 2007)
 * @since 1.5.0
 */
public class DiscourseMessages extends NLS {
	
	private static String BUNDLE_NAME = DiscourseMessages.class.getName(); //$NON-NLS-1$

	/** 
	 * This code loads the messages from the .properties file.
	 */
	static { 
		NLS.initializeMessages(BUNDLE_NAME, DiscourseMessages.class); 
	}
	
	/** 
	 * This class is not intended to be instantiated.
	 */
	private DiscourseMessages(){}
	
	private static ResourceBundle fBundle = ResourceBundle.getBundle(BUNDLE_NAME);

	public static ResourceBundle getBundle(){
		return fBundle;
	}
	
	public static String CHANGE_AddReference_name;
	public static String CHANGE_CreateEntity_name;
	public static String CHANGE_AddEntityProperties_name;
	public static String CHANGE_RemoveEntityProperties_name;
	public static String CHANGE_ModifyEntityProperties_name;
	public static String CHANGE_MoveReference_name;
	public static String CHANGE_RemoveReference_name;
	public static String CHANGE_RenameEntity_name;
	
}
