/* Filename: SelectFoldersDialog.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Feb 4, 2010
 */
package nil.ucm.indications2.ui.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.ui 1.0.0
 */
public class SelectResourcesDialog extends SelectResourceDialog {
	
	protected Text twoText;
	protected IResource two;

	/**
	 * TODO: Write comment
	 *
	 * @param parent
	 * @param type one of IResource.FILE, IResource.FOLDER, or IRESOURCE.PROJECT
	 * @since nil.ucm.indications2.ui 1.0.0
	 */
	public SelectResourcesDialog(Shell parent, int type) {
		super(parent, type);
	}
	
	public IResource getResourceTwo(){
		return two;
	}

	/* 
	 * (non-Javadoc) @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		 Composite composite = (Composite)super.createDialogArea(parent);

		 oneLabel.setText("First Target");
		 
		 Label label;
		 Button browse;
		 
		 // row for second
		 label = new Label(composite, SWT.NONE);
		 label.setText("Second Target");
		 label.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false));
		 
		 twoText = new Text(composite, SWT.BORDER);
		 twoText.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		 twoText.setEditable(false);
		 twoText.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_LIST_BACKGROUND));

		 browse = new Button(composite, SWT.PUSH);
		 browse.setText("B&rowse...");
		 browse.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
		 browse.addSelectionListener(new SelectionAdapter(){
				public void widgetSelected(SelectionEvent e) {
					two = selectResource();
					updateControls();
				}
			 });
		 
		 return composite;
	}
	
	protected void updateControls(){
				
		String oneName = (one == null) ? "" : one.getFullPath().toOSString();
		String twoName = (two == null) ? "" : two.getFullPath().toOSString();
		
		if(!oneText.getText().equals(oneName)) oneText.setText(oneName); 
		if(!twoText.getText().equals(twoName)) twoText.setText(twoName);
		
		if(checkType(one) && checkType(two)){
			updateStatus(new Status(IStatus.OK, " ", "Press OK to compare these two resources"));
		} else {
			updateStatus(new Status(IStatus.ERROR, " ", "Select two " + typeStr + " to compare"));
		}
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.dialogs.SelectResourceDialog#getTypeString(int)
	 */
	@Override
	protected String getTypeString(int type) {
		switch(type){
		case IResource.FILE: return "files";
		case IResource.FOLDER: return "folders";
		case IResource.PROJECT: return "projects";
		default: return "resources";
		}
	}

}
