/* Filename: NucleusController.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 01/10/2009
 */
package nil.ucm.indications2.ui.controllers;

import nil.ucm.indications2.core.rep.INucleus;
import nil.ucm.indications2.core.rep.model.INucleusModel;
import nil.ucm.indications2.core.rep.model.NucleusModel;
import edu.mit.story.ui.editor.IStoryEditor;

/** 
 *   Controller implementation for the INucleusModel
 *
 * @author Raquel Hervas
 * @version 1.0, (Jan. 11, 2010)
 * @since nil.ucm.indications.ui 1.0.0
 */
public class NucleusController extends IndArgController implements INucleusController {

	public NucleusController(IStoryEditor editor, String annoID) {
		super(new NucleusModel(editor.getStoryModel()), annoID, editor);
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.parsing.ui.controllers.SegmentSetController#getModel()
	 */
	@Override
	public INucleusModel getModel() {
		return (INucleusModel)super.getModel();
	}
	
	/* 
	 * (non-Javadoc) @see nil.ucm.indications.ui.controllers.INucleusController#load(nil.ucm.indications.core.rep.INucleus)
	 */
	public void load(INucleus nuc) {
		if(nuc != null) getModel().load(nuc);
	}

}
