/* Filename: CountResult.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Feb 9, 2010
 */
package nil.ucm.indications2.ui.agreement;

import org.eclipse.core.resources.IResource;

import edu.mit.story.core.measure.Result;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.ui 1.0.0
 */
public class CountResult extends Result implements ICountResult {
	
	public final int words;
	public final int sentences;
	public final int referents;
	public final int references;
	public final int maxReferences;
	public final int distReferences;
	public final int descReferences;
	public final int copReferences;
	public final int indications;
	public final int nuclei;
	public final int maxNuclei;
	public final int distNuclei;
	public final int descNuclei;
	public final int modifiers;
	public final int maxModifiers;
	public final int distModifiers;
	public final int descModifiers;
	public final ITimeResult timeResult;

	/**
	 * TODO: Write comment
	 *
	 * @param target
	 * @param message
	 * @since nil.ucm.indications2.ui 1.0.0
	 */
	public CountResult(IResource target, int words, int sentences, 
					   int referents, int references, int maxRefs, int distRefs, int descRefs, int copRefs,
					   int indications, int nuclei, int maxNuclei, int modifiers, int maxModifiers,
					   int distNucs, int descNucs, int distMods, int descMods, 
					   ITimeResult timeResult) {
		super(target);
		if(timeResult != null && timeResult.getTarget() != target) 
			throw new IllegalArgumentException();
		this.words = checkNum(words);
		this.sentences = checkNum(sentences);
		this.referents = checkNum(referents);
		this.references = checkNum(references);
		this.maxReferences = checkNum(maxRefs);
		this.distReferences = checkNum(distRefs);
		this.descReferences = checkNum(descRefs);
		this.copReferences = checkNum(copRefs);
		this.indications = checkNum(indications);
		this.nuclei = checkNum(nuclei);
		this.maxNuclei = checkNum(maxNuclei);
		this.distNuclei = checkNum(distNucs);
		this.descNuclei = checkNum(descNucs);
		this.modifiers = checkNum(modifiers);
		this.maxModifiers = checkNum(maxModifiers);
		this.distModifiers = checkNum(distMods);
		this.descModifiers = checkNum(descMods);
		if(timeResult == null){
			this.timeResult = new TimeResult(target, null, 0, 0, 0, 0);
		} else {
			this.timeResult = timeResult;
		}
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getIndications()
	 */
	public int getIndications() {
		return indications;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getMaxModifiers()
	 */
	public int getMaxModifiers() {
		return maxModifiers;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getMaxNuclei()
	 */
	public int getMaxNuclei() {
		return maxNuclei;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getDistinctiveNucs()
	 */
	public int getDistinctiveNucs() {
		return distNuclei;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getDescriptiveNucs()
	 */
	public int getDescriptiveNucs() {
		return descNuclei;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getMaxReferences()
	 */
	public int getMaxReferences() {
		return maxReferences;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getModifiers()
	 */
	public int getModifiers() {
		return modifiers;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getDescriptiveMods()
	 */
	public int getDescriptiveMods() {
		return descModifiers;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getDistinctiveMods()
	 */
	public int getDistinctiveMods() {
		return distModifiers;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getNuclei()
	 */
	public int getNuclei() {
		return nuclei;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getReferences()
	 */
	public int getReferences() {
		return references;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getReferents()
	 */
	public int getReferents() {
		return referents;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getWords()
	 */
	public int getWords() {
		return words;
	}
	
	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getSentences()
	 */
	public int getSentences() {
		return sentences;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getDescriptiveRefs()
	 */
	public int getDescriptiveRefs() {
		return descReferences;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getDistinctiveRefs()
	 */
	public int getDistinctiveRefs() {
		return distReferences;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getCopularRefs()
	 */
	public int getCopularRefs() {
		return copReferences;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ICountResult#getTimeResult()
	 */
	public ITimeResult getTimeResult() {
		return timeResult;
	}

	public String toString(boolean includeResourceName){
		StringBuilder sb = new StringBuilder();
		if(includeResourceName) 
			sb.append(getTarget().getName()).append('\t');
		sb.append(Integer.toString(words)).append('\t');
		sb.append(Integer.toString(sentences)).append('\t');
		sb.append(Integer.toString(referents)).append('\t');
		sb.append(Integer.toString(references)).append('\t');
		sb.append(Integer.toString(maxReferences)).append('\t');
		sb.append(Integer.toString(distReferences)).append('\t');
		sb.append(Integer.toString(descReferences)).append('\t');
		sb.append(Integer.toString(copReferences)).append('\t');
		sb.append(Integer.toString(indications)).append('\t');
		sb.append(Integer.toString(nuclei)).append('\t');
		sb.append(Integer.toString(maxNuclei)).append('\t');
		sb.append(Integer.toString(distNuclei)).append('\t');
		sb.append(Integer.toString(descNuclei)).append('\t');
		sb.append(Integer.toString(modifiers)).append('\t');
		sb.append(Integer.toString(maxModifiers)).append('\t');
		sb.append(Integer.toString(distModifiers)).append('\t');
		sb.append(Integer.toString(descModifiers)).append('\t');
		sb.append(timeResult.toString(false));
		return sb.toString();
	}
	
	public static String getHeaders(boolean incRes){
		StringBuilder sb = new StringBuilder();
		if(incRes) sb.append("Resource").append('\t');
		sb.append("Words").append('\t');
		sb.append("Sentences").append('\t');
		sb.append("Referents").append('\t');
		sb.append("References").append('\t');
		sb.append("Max References").append('\t');
		sb.append("Dist References").append('\t');
		sb.append("Desc References").append('\t');
		sb.append("Copular References").append('\t');
		sb.append("Indications").append('\t');
		sb.append("Nuclei").append('\t');
		sb.append("Max Nuclei").append('\t');
		sb.append("Dist Nuclei").append('\t');
		sb.append("Desc Nuclei").append('\t');
		sb.append("Modifiers").append('\t');
		sb.append("Max Modifiers").append('\t');
		sb.append("Dist Modifiers").append('\t');
		sb.append("Desc Modifiers").append('\t');
		sb.append(TimeResult.getHeaders("Merge", false));
		return sb.toString();
	}
		
	public static class CountResultBuilder {
		
		public int words;
		public int sentences;
		public int referents;
		public int references;
		public int maxReferences;
		public int distReferences;
		public int descReferences;
		public int copReferences;
		public int indications;
		public int nuclei;
		public int maxNuclei;
		public int distNuclei;
		public int descNuclei;
		public int modifiers;
		public int maxModifiers;
		public int distModifiers;
		public int descModifiers;
		public ITimeResult timeResult;
		
		public CountResult toResult(IResource r){
			return new CountResult(r, words, sentences, 
					               referents, references, maxReferences, distReferences, descReferences, copReferences,
					               indications, nuclei, maxNuclei, modifiers, maxModifiers,
					               distNuclei, descNuclei, distModifiers, descModifiers, 
					               timeResult);
		}
	}
}
