/* Filename: UnknownIndicationTypeProblem.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 02/11/2009
 */
package nil.ucm.indications2.core.rep.problems;

import java.util.Collections;
import java.util.Set;

import nil.ucm.indications2.core.rep.IndicationStructureRep;

import org.eclipse.core.resources.IMarker;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 *   Problem for the indication descriptions that have as type UNKNOWN. 
 *
 * @author Raquel Hervas
 * @version 1.0, (Jan. 11, 2010)
 * @since nil.ucm.indications.core 1.0.0
 */
public class MultipleIndicationsProblem extends StoryProblem {
	
	public static final String ID = "nil.ucm.indications2.core.problem.multipleIndication";
	
	public MultipleIndicationsProblem(IReference ref, String buildRuleID) {
		this(Collections.singleton(ref), buildRuleID);
	}

	public MultipleIndicationsProblem(Set<? extends IReference> refs, String buildRuleID) {
		super(IndicationStructureRep.getInstance(), buildRuleID);
		if(refs.isEmpty()) throw new IllegalArgumentException();

		setID(ID);
		setName("reference has multiple indications");
		setSeverity(IMarker.SEVERITY_ERROR);
		IHasPositionSet<IReference> rs = new HasPositionSet<IReference>(refs);
		setPosition(rs.first());
		
		StringBuilder sb = new StringBuilder();
		if(rs.size() == 1){
			IReference ref = rs.first();
			sb.append("The reference '");
			sb.append(ref.getDisplayText());
			sb.append("' has multiple associated indications");
		} else {
			sb.append("There are ");
			sb.append(Integer.toString(rs.size()));
			sb.append(" references with multiple associated indications (only first shown)");
		}
		setDescription(sb.toString());
	}

}
