/* Filename: ModifierModel.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 01/10/2009
 */
package nil.ucm.indications2.core.rep.model;

import nil.ucm.indications2.core.rep.IIndicationStructure;
import nil.ucm.indications2.core.rep.IModifier;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;

/** 
 *   Implementation for the IModifierModel interface. This model only contains an IModifier.
 *
 * @author Raquel Hervas
 * @version 1.0, (Jan. 11, 2010)
 * @since nil.ucm.indications.ui 1.0.0
 */
public class ModifierModel extends IndArgModel implements IModifierModel {

	private IModifier loaded;
	
	public ModifierModel(IStoryModel storyModel) {
		super(storyModel);
	}
	
	/* 
	 * (non-Javadoc) @see nil.ucm.indications.ui.models.INucleusModel#getLoaded()
	 */
	
	public IModifier getLoaded() {
		return loaded;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications.ui.models.INucleusModel#load(nil.ucm.indications.core.rep.INucleus)
	 */
	
	public void load(IModifier mod) {
		internalClear();
		this.loaded = mod;
		setSegments(mod.getSegments());
		setType(mod.getType());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.parsing.ui.models.SegmentSetModel#clear()
	 */
	@Override
	public void internalClear() {
		this.loaded = null;
		super.internalClear();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#calculatePosition()
	 */
	
	public IHasPosition calculatePosition() {
		return PositionUtils.makePosition(getSegments());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#getDisplayPosition()
	 */
	
	public IHasPosition getDisplayPosition() {
		throw new UnsupportedOperationException();
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#recalculate(edu.mit.story.core.model.IStoryModel)
	 */
	
	public IStructuredData recalculate(IDesc container, IStoryModel model) {
		// implement if needed
		return loaded.recalculate(container, model);
	}

	
	public IIndicationStructure getParent() {
		return null;
	}

	
	public void setParent(IIndicationStructure p) {	}

}
