/* Filename: IModifierModel.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 01/10/2009
 */
package nil.ucm.indications2.core.rep.model;

import nil.ucm.indications2.core.rep.IModifier;
import nil.ucm.indications2.core.rep.IndicationType;

/** 
 *   A model for the IModifier components of the IIndicationStructure model
 *
 * @author Raquel Hervas
 * @version 1.0, (Oct. 1, 2009)
 * @since nil.ucm.indications.ui 1.0.0
 */
public interface IModifierModel extends IModifier, IIndArgModel {

	/**
	 *   Returns the loaded modifier object; if there isn't one, returns
	 * <code>null</code>
	 * 
	 * @return the loaded modifier object, if one exists, otherwise
	 *         <code>null</code>
	 */
	public IModifier getLoaded();

	/**
	 *   Loads the specified modifier into the model, so that it's attributes can
	 * be modified. Changes to the model, once loaded, do not affect the
	 * original object.
	 * 
	 * @param nuc
	 *            the modifier to be loaded into the model.
	 * @throws NullPointerException
	 *             if the specified modifier is <code>null</code>
	 * @since edu.mit.discourse.ui 1.0.0
	 */
	public void load(IModifier nuc);
	
	
	public void setType(IndicationType t);

}
