/* Filename: Constituent.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: May 7, 2010
 */
package nil.ucm.indications2.core.rep.indication;

import java.util.Collection;

import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.core 1.0.0
 */
public abstract class Constituent implements IConstituent {
	
	private final IIndication parent;
	private final IndicationType type;
	private final ISegmentSet segments;
	
	public Constituent(IIndication parent, IndicationType type, Collection<? extends ISegment> segments){
		if(parent == null)
			throw new NullPointerException();
		if(type == null)
			throw new NullPointerException();
		if(segments.isEmpty())
			throw new IllegalArgumentException();
		
		this.parent = parent;
		this.type = type;
		this.segments = (segments instanceof ISegmentSet) ? (ISegmentSet)segments : new SegmentSet(segments);
		if(this.segments.getRep() != TokenRep.getInstance())
			throw new IllegalArgumentException();
		
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.core.rep.indication.IConstituent#getParent()
	 */
	public IIndication getParent() {
		return parent;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.core.rep.indication.IConstituent#getType()
	 */
	public IndicationType getType() {
		return type;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.core.rep.indication.IConstituent#getSegments()
	 */
	public ISegmentSet getSegments() {
		return segments;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#calculatePosition()
	 */
	public IHasPosition calculatePosition() {
		return segments;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#getDisplayPosition()
	 */
	public IHasPosition getDisplayPosition() {
		return segments;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IHasRep#getRep()
	 */
	public IRep getRep() {
		return segments.getRep();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getLength()
	 */
	public int getLength() {
		return segments.getLength();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getOffset()
	 */
	public int getOffset() {
		return segments.getOffset();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getRightOffset()
	 */
	public int getRightOffset() {
		return segments.getRightOffset();
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IData#equals(edu.mit.story.core.desc.IData, edu.mit.story.core.align.IAlignedStoryModel)
	 */
	public boolean equals(IData tgtData, IAlignedStoryModel model) {
		if(this == tgtData)
			return true;
		if(!IConstituent.class.isAssignableFrom(tgtData.getClass()))
			return false;
		IConstituent tgtCon = (IConstituent)tgtData;
		
		if(!getType().equals(tgtCon.getType()))
			return false;
		if(!segments.equals(tgtCon.getSegments(), model))
			return false;
		
		return true;
	}
	
}
