/* Filename: IndexedIndication.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 26/10/2009
 */
package nil.ucm.indications2.core.rep;

import java.util.Iterator;
import java.util.List;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.factory.IndexedData;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author Raquel Hervas
 * @version 1.0, (Jan. 11, 2010)
 * @since nil.ucm.indications.core 1.0.0
 */
public class IndexedIndication extends IndexedData<IIndicationStructure> {

	public IndexedIndication(IHasPosition p, IIndicationStructure data) {
		super(p,data);		
	}
	
	public boolean replaces(IDesc desc){
		
		long thisRefDescId = ((IIndicationStructure)this.getData()).getReferentDescription().getID();
		long thisRefId = ((IIndicationStructure)this.getData()).getReference().getID();
		
		long refDescId = ((IIndicationStructure)desc.getData()).getReferentDescription().getID();
		long refId = ((IIndicationStructure)desc.getData()).getReference().getID();
		
		return (thisRefDescId == refDescId && thisRefId == refId);
	}
	
	public boolean equals(Object o){
		
		if(o instanceof IDesc){
			IDesc d = (IDesc)o;
			if(IndicationStructureRep.getInstance().isType(d)){
				o = (IIndicationStructure)d.getData();
			}
		}
		
		
		if(o instanceof IIndicationStructure){
			IIndicationStructure me = getData();
			IIndicationStructure it = (IIndicationStructure)o;
			if(it.getReferentDescription().getID() != me.getReferentDescription().getID()) return false;
			if(!refsEqual(me.getReference(), it.getReference())) return false;
			
			// nuclei
			List<? extends INucleus> myNucs = me.getNuclei();
			List<? extends INucleus> itNucs = it.getNuclei();
			if(myNucs.size() != itNucs.size()) return false;
			for(int i = 0; i < myNucs.size(); i++) if(!nucsEqual(myNucs.get(i), itNucs.get(i))) return false;
			
			// modifiers
			List<? extends IModifier> myMods = me.getModifiers();
			List<? extends IModifier> itMods = it.getModifiers();
			if(myMods.size() != itMods.size()) return false;
			for(int i = 0; i < myMods.size(); i++) if(!modsEqual(myMods.get(i), itMods.get(i))) return false;
			
			return true;
		}
		
		return super.equals(o);
	}
	
	protected boolean refsEqual(IReference myRef, IReference itRef){
		if(myRef.getID() != itRef.getID()) return false;
		IHasPositionSet<ISegment> mySegs = myRef.getSegments();
		IHasPositionSet<ISegment> itSegs = itRef.getSegments();
		if(mySegs.size() != itSegs.size()) return false;
		Iterator<ISegment> myItr = mySegs.iterator();
		Iterator<ISegment> itItr = itSegs.iterator();
		for(; myItr.hasNext() && itItr.hasNext(); ){
			if(!segsEqual(myItr.next(), itItr.next())) return false;
		}
		return true;
	}
	
	protected boolean nucsEqual(INucleus myNuc, INucleus itNuc){
		if(myNuc.getType() != itNuc.getType()) return false;
		IHasPositionSet<ISegment> mySegs = myNuc.getSegments();
		IHasPositionSet<ISegment> itSegs = itNuc.getSegments();
		if(mySegs.size() != itSegs.size()) return false;
		Iterator<ISegment> myItr = mySegs.iterator();
		Iterator<ISegment> itItr = itSegs.iterator();
		for(; myItr.hasNext() && itItr.hasNext(); ){
			if(!segsEqual(myItr.next(), itItr.next())) return false;
		}
		return true;
	}
	
	protected boolean modsEqual(IModifier myMod, IModifier itMod){
		if(myMod.getType() != itMod.getType()) return false;
		IHasPositionSet<ISegment> mySegs = myMod.getSegments();
		IHasPositionSet<ISegment> itSegs = itMod.getSegments();
		if(mySegs.size() != itSegs.size()) return false;
		Iterator<ISegment> myItr = mySegs.iterator();
		Iterator<ISegment> itItr = itSegs.iterator();
		for(; myItr.hasNext() && itItr.hasNext(); ){
			if(!segsEqual(myItr.next(), itItr.next())) return false;
		}
		return true;
	}
	
	protected boolean segsEqual(ISegment mySeg, ISegment itSeg){
		return mySeg.getDescs().equals(itSeg.getDescs());
	}
}
