/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.timebank;

import edu.mit.semantics.core.SemanticsPlugin;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class TimeMLHandler
extends DefaultHandler {
    private StringBuilder text = new StringBuilder();
    private StringBuilder buffer = new StringBuilder();
    private List<String> words = new LinkedList<String>();
    private List<List<String>> elements = new LinkedList<List<String>>();
    private List<String> element = null;

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("TimeML".equals(name)) {
            return;
        }
        if (this.element != null) {
            throw new IllegalStateException();
        }
        this.element = new LinkedList<String>();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        int end = start + length;
        int i = start;
        while (i < end) {
            char c = ch[i];
            if (Character.isWhitespace(c)) {
                this.wordEnded();
                this.text.append(c);
            } else {
                this.buffer.append(c);
            }
            ++i;
        }
    }

    protected void wordEnded() {
        if (this.buffer.length() == 0) {
            return;
        }
        this.text.append((CharSequence)this.buffer);
        String word = this.buffer.toString();
        this.buffer.setLength(0);
        this.words.add(word);
        if (this.element != null) {
            this.element.add(word);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        this.wordEnded();
        if (this.element != null) {
            if (!this.element.isEmpty()) {
                this.elements.add(this.element);
            }
            this.element = null;
        }
    }

    public static void main(String[] args) {
        TimeMLHandler handler;
        block16: {
            Status status;
            handler = new TimeMLHandler();
            InputStream is = TimeMLHandler.class.getResourceAsStream("NYT19980206.0460.tml");
            try {
                try {
                    InputSource inputSource = new InputSource(new BufferedInputStream(is));
                    XMLReader parser = XMLReaderFactory.createXMLReader();
                    parser.setFeature("http://xml.org/sax/features/namespaces", false);
                    parser.setFeature("http://xml.org/sax/features/validation", false);
                    parser.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                    parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    parser.setContentHandler(handler);
                    parser.parse(inputSource);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block16;
                    }
                    catch (IOException e2) {
                        status = new Status(4, SemanticsPlugin.getDefault().getBundle().getSymbolicName(), "Error closing frame xml file", (Throwable)e2);
                        SemanticsPlugin.getDefault().getLog().log((IStatus)status);
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    Status status2 = new Status(4, SemanticsPlugin.getDefault().getBundle().getSymbolicName(), "Error closing frame xml file", (Throwable)e);
                    SemanticsPlugin.getDefault().getLog().log((IStatus)status2);
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                status = new Status(4, SemanticsPlugin.getDefault().getBundle().getSymbolicName(), "Error closing frame xml file", (Throwable)e);
                SemanticsPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        System.out.println(handler.text.toString());
        for (String string : handler.words) {
            System.err.println(string);
        }
        System.out.println();
        for (List list : handler.elements) {
            System.out.println(list);
        }
    }
}

