/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.valence.rules;

import com.google.common.collect.LinkedHashMultimap;
import edu.mit.semantics.core.rep.valence.IEventValence;
import edu.mit.semantics.core.rep.valence.ValenceRep;
import edu.mit.semantics.core.rep.valence.problems.MultipleValenceProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleValence
extends AbstractBuildRule {
    public static final String ID = SingleValence.class.getCanonicalName();

    public SingleValence() {
        super(ValenceRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        if (!model.supports(ValenceRep.getInstance())) {
            return null;
        }
        LinkedHashMultimap eventsToValences = LinkedHashMultimap.create();
        for (IDesc valD : model.getData().getDescriptions(ValenceRep.getInstance())) {
            IEventValence eval = (IEventValence)valD.getData();
            eventsToValences.put((Object)eval.getEvent(), (Object)valD);
        }
        HasPositionSet result = new HasPositionSet();
        for (Map.Entry e : eventsToValences.asMap().entrySet()) {
            if (((Collection)e.getValue()).size() <= 1) continue;
            result.add((Object)new MultipleValenceProblem((IDesc)e.getKey(), ((Collection)e.getValue()).size(), this.getID()));
        }
        return result;
    }
}

