/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.valence;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.valence.EventValence;
import edu.mit.semantics.core.rep.valence.IEventValence;
import edu.mit.semantics.core.rep.valence.Valence;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Version;

public class ValenceRep
extends AbstractRep {
    public static final String ID = "edu.mit.semantics.rep.valence";
    private static IRep instance;

    public static IRep getInstance() {
        if (instance == null) {
            instance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return instance;
    }

    public ValenceRep() {
        super(IEventValence.class, v01);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)EventRep.getInstance());
    }

    public String serialize(IData data) {
        IEventValence actor = (IEventValence)data;
        return this.serializeV01(actor);
    }

    public IEventValence reconstitute(IHasPosition p, String description, IStoryModel model) {
        return this.reconstitute(p, description, model, this.getVersion());
    }

    public IEventValence reconstitute(IHasPosition p, String description, IStoryModel model, Version version) {
        if (v01.equals((Object)version)) {
            return this.reconstituteV01(p, description, model);
        }
        return this.reconstitute(p, description, model, this.getVersion());
    }

    protected String serializeV01(IEventValence data) {
        ArrayList<String> fields = new ArrayList<String>(2);
        fields.add(Long.toString(data.getEvent().getID()));
        fields.add(data.getValence().name());
        return BlockMapper.PIPE.serialize(fields);
    }

    protected IEventValence reconstituteV01(IHasPosition p, String description, IStoryModel model) {
        List fields = BlockMapper.PIPE.reconstitute(description);
        long eid = Long.parseLong((String)fields.get(0));
        IDesc event = model.getData().getDescriptions(EventRep.getInstance()).getDescription(eid);
        Valence val = Valence.valueOf((String)fields.get(1));
        return new EventValence(val, event);
    }
}

