/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timelink.problems;

import edu.mit.semantics.core.rep.timelink.ITimeLink;
import edu.mit.semantics.core.rep.timelink.LinkTypeTemporal;
import edu.mit.semantics.core.rep.timelink.TimeLinkRep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collections;

public class DuringTargetProblem
extends StoryProblem {
    public static final String ID = "edu.mit.semantics.timelink.problem.duringTarget";

    public DuringTargetProblem(IDesc desc, String buildRuleID) {
        super(TimeLinkRep.getInstance(), buildRuleID);
        String alternate;
        String target;
        this.setID(ID);
        this.setName("non-timex during target");
        this.setSeverity(2);
        this.setDescs(Collections.singleton(desc));
        IDescSet links = this.getDescs().getDescriptions(TimeLinkRep.getInstance());
        if (links.size() != 1) {
            throw new IllegalArgumentException();
        }
        this.setPosition((IHasPosition)desc);
        ITimeLink link = (ITimeLink)desc.getData();
        StringBuilder sb = new StringBuilder();
        boolean hasSignal = link.getSignal() != null;
        sb.append(hasSignal ? "The " : "This ");
        if (link.getRelationType() == LinkTypeTemporal.DURING) {
            sb.append(LinkTypeTemporal.DURING.name());
            target = "related";
            alternate = LinkTypeTemporal.IS_INCLUDED.name();
        } else if (link.getRelationType() == LinkTypeTemporal.DURING_INV) {
            sb.append(LinkTypeTemporal.DURING_INV.name());
            target = "source";
            alternate = LinkTypeTemporal.INCLUDES.name();
        } else {
            throw new IllegalArgumentException();
        }
        sb.append(" timelink ");
        if (hasSignal) {
            sb.append("'");
            sb.append(link.getSignal().getDisplayText());
            sb.append("' ");
        }
        sb.append("does not have a time expression as its ");
        sb.append(target);
        sb.append(" target; use ");
        sb.append(alternate);
        sb.append(" instead");
        this.setDescription(sb.toString());
    }
}

