/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.semrole;

import edu.mit.jpropbank.Aspect;
import edu.mit.jpropbank.Form;
import edu.mit.jpropbank.IArg;
import edu.mit.jpropbank.INode;
import edu.mit.jpropbank.IPredicateFeatures;
import edu.mit.jpropbank.Predicate;
import edu.mit.jpropbank.Tense;
import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.semantics.core.rep.semrole.ISemArg;
import edu.mit.semantics.core.rep.semrole.ISemRole;
import edu.mit.semantics.core.rep.semrole.ITreeNode;
import edu.mit.semantics.core.rep.semrole.SemArg;
import edu.mit.semantics.core.rep.semrole.SemRoleRep;
import edu.mit.semantics.core.rep.semrole.TreeNode;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Data;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemRole
extends Predicate<ISemArg>
implements ISemRole {
    public static final String unknownFramesetID = "lemma.XX";
    public static final String defaultUser = "user";
    private final IDesc parse;
    private final ITree predicate;
    private final IRoleset roleset;

    public SemRole(IRoleset roleset, IDesc parse, int terminal, IPredicateFeatures features, List<? extends ISemArg> args) {
        this(roleset, parse, terminal, features, args, true);
    }

    public SemRole(IRoleset roleset, IDesc parse, int terminal, IPredicateFeatures features, List<? extends ISemArg> args, boolean reallocate) {
        super(terminal, features.getForm(), features.getTense(), features.getAspect(), features.isThirdPerson(), features.isActive(), args, reallocate);
        if (roleset == null) {
            throw new NullPointerException();
        }
        this.parse = parse;
        this.predicate = (ITree)((ITree)parse.getData()).getRoot().getLeaves().get(terminal);
        this.roleset = roleset;
    }

    public SemRole(IRoleset roleset, IDesc parse, int terminal, Form form, Tense tense, Aspect aspect, boolean isThirdPerson, boolean isActive, List<? extends ISemArg> args) {
        this(roleset, parse, terminal, form, tense, aspect, isThirdPerson, isActive, args, true);
    }

    public SemRole(IRoleset roleset, IDesc parse, int terminal, Form form, Tense tense, Aspect aspect, boolean isThirdPerson, boolean isActive, List<? extends ISemArg> args, boolean reallocate) {
        super(terminal, form, tense, aspect, isThirdPerson, isActive, args, reallocate);
        if (roleset == null) {
            throw new NullPointerException();
        }
        this.parse = parse;
        this.predicate = (ITree)((ITree)parse.getData()).getRoot().getLeaves().get(terminal);
        this.roleset = roleset;
    }

    @Override
    public ITree getPredicate() {
        return this.predicate;
    }

    @Override
    public IDesc getParse() {
        return this.parse;
    }

    @Override
    public IRoleset getRoleset() {
        return this.roleset;
    }

    public IHasPosition getDisplayPosition() {
        return this.getPredicate().calculatePosition();
    }

    public IHasPosition calculatePosition() {
        IHasPosition result = null;
        for (IArg arg : this.getArguments()) {
            for (List nodes : arg.getLocation()) {
                for (ITreeNode node : nodes) {
                    result = PositionUtils.combine(result, (IHasPosition)node.getTree().getTokens());
                }
            }
        }
        return PositionUtils.combine(result, (IHasPosition)this.predicate.getTokens());
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        IDesc newParse = model.getData().getDescriptions(this.parse.getRep()).getDescription(this.parse.getID());
        if (newParse == this.parse) {
            return this;
        }
        if (newParse == null) {
            return null;
        }
        ITree tree = (ITree)newParse.getData();
        ArrayList<ISemArg> args = new ArrayList<ISemArg>(this.getArguments().size());
        for (ISemArg arg : this.getArguments()) {
            args.add(SemRole.recalculate(this.roleset, arg, tree));
        }
        return new SemRole(this.roleset, newParse, this.getTerminal(), this.getForm(), this.getTense(), this.getAspect(), this.isThirdPerson(), this.isActive(), args, false);
    }

    public static ISemArg recalculate(IRoleset roleset, IArg<? extends INode> oldArg, ITree newTree) {
        List oldLoc = oldArg.getLocation();
        ArrayList<List<ITreeNode>> newLoc = new ArrayList<List<ITreeNode>>(oldLoc.size());
        List leaves = newTree.getRoot().getLeaves();
        for (List oldSplit : oldLoc) {
            ArrayList<TreeNode> newSplit = new ArrayList<TreeNode>(oldSplit.size());
            newLoc.add(newSplit);
            for (INode oldNode : oldSplit) {
                ITree newNode = (ITree)leaves.get(oldNode.getTerminal());
                while (newNode.getHeight() != oldNode.getHeight()) {
                    newNode = newNode.getParent();
                }
                newSplit.add(new TreeNode(newNode));
            }
        }
        return new SemArg(roleset, oldArg.getLabel(), oldArg.getFeature(), newLoc);
    }

    public String toString() {
        return String.valueOf(this.predicate.getTokens().toString()) + ' ' + SemRoleRep.getInstance().serialize((IData)this);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (this == tgtData) {
            return true;
        }
        if (!ISemRole.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        ISemRole tgtRole = (ISemRole)tgtData;
        if (this.isActive() != tgtRole.isActive()) {
            return false;
        }
        if (this.isThirdPerson() != tgtRole.isThirdPerson()) {
            return false;
        }
        if (this.getTerminal() != tgtRole.getTerminal()) {
            return false;
        }
        if (!this.getForm().equals((Object)tgtRole.getForm())) {
            return false;
        }
        if (!this.getTense().equals((Object)tgtRole.getTense())) {
            return false;
        }
        if (!this.getAspect().equals((Object)tgtRole.getAspect())) {
            return false;
        }
        if (!this.roleset.equals(tgtRole.getRoleset())) {
            return false;
        }
        if (!this.parse.equals(tgtRole.getParse(), model)) {
            return false;
        }
        int numArgs = this.getArguments().size();
        if (numArgs != tgtRole.getArguments().size()) {
            return false;
        }
        int i = 0;
        while (i < numArgs) {
            if (!this.argsEqual((ISemArg)this.getArguments().get(i), (ISemArg)tgtRole.getArguments().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean argsEqual(ISemArg srcArg, ISemArg tgtArg) {
        if (!srcArg.getLabel().equals(tgtArg.getLabel())) {
            return false;
        }
        if (!srcArg.getFeature().equals(tgtArg.getFeature())) {
            return false;
        }
        if (!Data.equals((Object)srcArg.getRole(), (Object)tgtArg.getRole())) {
            return false;
        }
        int numLinks = srcArg.getLocation().size();
        if (numLinks != tgtArg.getLocation().size()) {
            return false;
        }
        int i = 0;
        while (i < numLinks) {
            if (!this.linksEqual((List)srcArg.getLocation().get(i), (List)tgtArg.getLocation().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean linksEqual(List<ITreeNode> srcNodes, List<ITreeNode> tgtNodes) {
        int numNodes = srcNodes.size();
        if (numNodes != tgtNodes.size()) {
            return false;
        }
        int i = 0;
        while (i < numNodes) {
            if (!this.nodesEqual(srcNodes.get(i), tgtNodes.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean nodesEqual(ITreeNode srcNode, ITreeNode tgtNode) {
        if (srcNode.getHeight() != tgtNode.getHeight()) {
            return false;
        }
        return tgtNode.getTerminal() == srcNode.getTerminal();
    }
}

