/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.semrole;

import edu.mit.jpropbank.Arg;
import edu.mit.jpropbank.frames.IRole;
import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.propbank.GenericRoleSet;
import edu.mit.semantics.core.rep.semrole.ISemArg;
import edu.mit.semantics.core.rep.semrole.ITreeNode;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ImmutableDescSet;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemArg
extends Arg<ITreeNode>
implements ISemArg {
    private final IRole role;
    private IDescSet tokens;

    public SemArg(IRole role, List<List<ITreeNode>> locs) {
        super(role.getLabel(), role.getFeature(), locs);
        this.role = role;
    }

    public SemArg(IRoleset roleset, String label, String feature, List<List<ITreeNode>> locs) {
        super(label, feature, locs);
        if (roleset == null) {
            roleset = GenericRoleSet.getInstance();
        }
        this.role = roleset.getRole(label, feature);
    }

    @Override
    public IRole getRole() {
        return this.role;
    }

    @Override
    public IDescSet getTokens() {
        if (this.tokens == null) {
            HashSet hidden = new HashSet();
            for (List trace : this.getLocation()) {
                for (ITreeNode split : trace) {
                    hidden.addAll(split.getTree().getTokens());
                }
            }
            this.tokens = new ImmutableDescSet(TokenRep.getInstance(), hidden);
        }
        return this.tokens;
    }

    public int getLength() {
        return this.getTokens().getLength();
    }

    public int getOffset() {
        return this.getTokens().getOffset();
    }

    public int getRightOffset() {
        return this.getTokens().getRightOffset();
    }
}

