/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.move;

import edu.mit.semantics.core.rep.function.FunctionRep;
import edu.mit.semantics.core.rep.move.IMove;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.rep.IHasRep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Move
implements IMove {
    private final int number;
    private final List<IDesc> functions;
    private final IHasPosition position;

    public Move(int number, Collection<? extends IDesc> functions) {
        this.number = Move.checkMoveNumber(number);
        this.functions = Move.createFunctionList(functions);
        this.position = PositionUtils.combineAll(functions);
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public List<IDesc> getFunctions() {
        return this.functions;
    }

    public IHasPosition calculatePosition() {
        return this.position;
    }

    public IHasPosition getDisplayPosition() {
        return this.position;
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        IDescSet funcDescs = model.getData().getDescriptions(FunctionRep.getInstance());
        LinkedList<IDesc> newFunctions = new LinkedList<IDesc>();
        boolean changed = false;
        for (IDesc oldFunc : this.functions) {
            IDesc newFunc = funcDescs.getDescription(oldFunc.getID());
            changed |= newFunc != oldFunc;
            if (newFunc == null) continue;
            newFunctions.add(newFunc);
        }
        if (!changed) {
            return this;
        }
        if (newFunctions.isEmpty()) {
            return null;
        }
        return new Move(this.number, newFunctions);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (this == tgtData) {
            return true;
        }
        if (!IMove.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        IMove tgtMove = (IMove)tgtData;
        if (this.number != tgtMove.getNumber()) {
            return false;
        }
        return Desc.equals(this.getFunctions(), tgtMove.getFunctions(), (IAlignedStoryModel)model);
    }

    public static int checkMoveNumber(int number) {
        if (!Move.isValidMoveNumber(number)) {
            throw new IllegalArgumentException();
        }
        return number;
    }

    public static boolean isValidMoveNumber(int number) {
        return number > 0;
    }

    public static List<IDesc> createFunctionList(Collection<? extends IDesc> functions) {
        if (functions == null) {
            throw new NullPointerException();
        }
        if (functions.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<IDesc> hidden = new ArrayList<IDesc>(functions.size());
        for (IDesc iDesc : functions) {
            if (iDesc == null) {
                throw new NullPointerException();
            }
            if (!FunctionRep.getInstance().isType((IHasRep)iDesc)) {
                throw new IllegalArgumentException();
            }
            if (hidden.contains(iDesc)) {
                throw new IllegalArgumentException();
            }
            hidden.add(iDesc);
        }
        return Collections.unmodifiableList(hidden);
    }
}

