/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.mentalstate.model;

import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.mentalstate.IMentalState;
import edu.mit.semantics.core.rep.mentalstate.MentalState;
import edu.mit.semantics.core.rep.mentalstate.MentalStateRep;
import edu.mit.semantics.core.rep.mentalstate.model.IMentalStateModel;
import edu.mit.semantics.core.rep.valence.Valence;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.datamodel.DescModel;
import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.validation.Message;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;

public class MentalStateModel
extends AbstractViewModel
implements IMentalStateModel {
    public static final Message msgSelectEvent = new Message("Please select an event", 3);
    public static final Message msgSelectChar = new Message("Please select an character", 3);
    public static final Message msgSelectValence = new Message("Please specify a valence", 3);
    private final IStoryModel model;
    private final IDescModel charDescModel;
    private final IDescModel eventDescModel;
    private Valence value;
    protected IDesc loaded = null;

    public MentalStateModel(IStoryModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        Valence value = this.getDefaultValence0();
        DescModel charDescModel = new DescModel(model, new IRep[]{CorefRep.getInstance()});
        DescModel eventDescModel = new DescModel(model, new IRep[]{EventRep.getInstance()});
        charDescModel.setDefaultErrorMessage((IMessageProvider)msgSelectChar);
        eventDescModel.setDefaultErrorMessage((IMessageProvider)msgSelectEvent);
        ChangeListener cl = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MentalStateModel.this.fireChanged();
            }
        };
        charDescModel.addChangeListener(cl);
        eventDescModel.addChangeListener(cl);
        this.model = model;
        this.value = value;
        this.charDescModel = charDescModel;
        this.eventDescModel = eventDescModel;
    }

    private Valence getDefaultValence0() {
        Valence result = this.getDefaultValence();
        return result == null ? Valence.UNSPECIFIED : result;
    }

    protected Valence getDefaultValence() {
        return Valence.UNSPECIFIED;
    }

    public void setValence(Valence newValue) {
        if (newValue == null) {
            newValue = Valence.UNSPECIFIED;
        }
        if (newValue == this.value) {
            return;
        }
        this.value = newValue;
        this.fireChanged();
    }

    public IStoryModel getStoryModel() {
        return this.model;
    }

    public IDescModel getCharacterModel() {
        return this.charDescModel;
    }

    public IDescModel getEventModel() {
        return this.eventDescModel;
    }

    public IDesc getLoaded() {
        return this.loaded;
    }

    public void load(IDesc desc) {
        if (desc == this.loaded) {
            return;
        }
        if (!MentalStateRep.getInstance().isType((IHasRep)desc)) {
            throw new IllegalArgumentException();
        }
        this.internalClear();
        if (desc == null) {
            return;
        }
        IMentalState state = (IMentalState)desc.getData();
        this.loaded = desc;
        this.value = state.getValence();
        this.charDescModel.setDesc(state.getCharacter());
        this.eventDescModel.setDesc(state.getEvent());
    }

    public boolean isCleared() {
        if (this.loaded != null) {
            return false;
        }
        if (this.value != this.getDefaultValence()) {
            return false;
        }
        if (!this.charDescModel.isCleared()) {
            return false;
        }
        return this.eventDescModel.isCleared();
    }

    protected void internalClear() {
        this.loaded = null;
        this.value = this.getDefaultValence();
        this.charDescModel.clear();
        this.eventDescModel.clear();
    }

    protected IMessageProvider calculateMessage() {
        Message message = Message.NO_MESSAGE;
        if (this.value == Valence.UNSPECIFIED) {
            message = msgSelectValence;
        }
        if (this.eventDescModel.getMessageType() > message.getMessageType()) {
            message = new Message(this.eventDescModel.getMessage(), this.eventDescModel.getMessageType());
        }
        if (this.charDescModel.getMessageType() > message.getMessageType()) {
            message = new Message(this.charDescModel.getMessage(), this.charDescModel.getMessageType());
        }
        return message;
    }

    public IMentalState create() {
        return new MentalState(this.value, this.charDescModel.getDesc(), this.eventDescModel.getDesc());
    }

    public IDesc getCharacter() {
        return this.charDescModel.getDesc();
    }

    public IDesc getEvent() {
        return this.eventDescModel.getDesc();
    }

    public Valence getValence() {
        return this.value;
    }

    public IHasPosition calculatePosition() {
        return PositionUtils.combine((IHasPosition)this.eventDescModel.getDesc(), (IHasPosition)this.charDescModel.getDesc());
    }

    public IHasPosition getDisplayPosition() {
        return this.eventDescModel.getDesc();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        throw new UnsupportedOperationException();
    }
}

