/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.function;

import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.function.Function;
import edu.mit.semantics.core.rep.function.FunctionInstance;
import edu.mit.semantics.core.rep.function.FunctionTag;
import edu.mit.semantics.core.rep.function.IFunction;
import edu.mit.semantics.core.rep.function.IFunctionInstance;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.util.EntryImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionRep
extends AbstractRep {
    public static final String ID = "edu.mit.semantics.rep.function";
    private static IRep instance;

    public static IRep getInstance() {
        if (instance == null) {
            instance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return instance;
    }

    public FunctionRep() {
        super(IFunction.class, v02);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)TokenRep.getInstance());
    }

    public String serialize(IData data) {
        IFunction function = (IFunction)data;
        ArrayList<String> fields = new ArrayList<String>(function.getInstances().size() + 1);
        fields.add(FunctionTag.serialize(function.getFunctionTag()));
        for (IFunctionInstance inst : function.getInstances()) {
            fields.add(FunctionInstance.serialize(inst));
        }
        return BlockMapper.PIPE.serialize(fields);
    }

    public IData reconstitute(IHasPosition p, String description, IStoryModel model) {
        return this.reconstitute(p, description, model, this.getVersion());
    }

    public IData reconstitute(IHasPosition p, String description, IStoryModel model, Version version) {
        if (v1.equals((Object)version)) {
            version = v01;
        }
        if (v01.equals((Object)version)) {
            return this.reconstituteV01(p, description, model);
        }
        if (v02.equals((Object)version)) {
            return this.reconstituteV02(p, description, model);
        }
        return this.reconstitute(p, description, model, this.getVersion());
    }

    protected IFunction reconstituteV02(IHasPosition p, String desc, IStoryModel model) {
        List fields = BlockMapper.PIPE.reconstitute(desc);
        FunctionTag tag = FunctionTag.reconstitute((String)fields.get(0));
        ArrayList<FunctionInstance> instances = new ArrayList<FunctionInstance>(fields.size() - 1);
        int i = 1;
        while (i < fields.size()) {
            instances.add(FunctionInstance.reconstitute((String)fields.get(i), model));
            ++i;
        }
        return new Function(tag, instances);
    }

    protected IFunction reconstituteV01(IHasPosition p, String description, IStoryModel model) {
        List fields = BlockMapper.PIPE.reconstitute(description);
        Map.Entry<String, String> tag = this.reconstituteV01FunctionTag((String)fields.get(0));
        ISegment seg = Segment.reconstitute((String)((String)fields.get(1)), (IRep)TokenRep.getInstance(), (IStoryData)model.getData());
        String subtype = tag.getValue();
        boolean isInverted = subtype.startsWith("_");
        if (isInverted) {
            subtype = subtype.substring(1, subtype.length());
        }
        FunctionTag funcTag = new FunctionTag(tag.getKey(), isInverted, subtype);
        FunctionInstance instance = new FunctionInstance(IFunctionInstance.InstanceType.ACTUAL, Collections.singleton(seg));
        return new Function(funcTag, Collections.singleton(instance));
    }

    protected Map.Entry<String, String> reconstituteV01FunctionTag(String str) {
        int idx = str.indexOf(95);
        if (idx == -1) {
            return new EntryImpl((Object)str, (Object)"");
        }
        String symbol = str.substring(0, idx);
        String subtype = str.substring(idx + 1, str.length());
        return new EntryImpl((Object)symbol, (Object)subtype);
    }
}

