/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event.rules;

import edu.mit.semantics.core.rep.event.Aspect;
import edu.mit.semantics.core.rep.event.EventClassifer;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.event.Tense;
import edu.mit.semantics.core.rep.event.model.EventModel;
import edu.mit.semantics.core.rep.event.problems.UnexpectedTenseAspectProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.meta.check.ICheck;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.util.EntryImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckTenseAspectRule
extends AbstractBuildRule {
    public static final String ID = CheckTenseAspectRule.class.getCanonicalName();

    public CheckTenseAspectRule() {
        super(EventRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        HashMap<IDesc, Map.Entry<Tense, Aspect>> problems = new HashMap<IDesc, Map.Entry<Tense, Aspect>>();
        EventClassifer classifier = EventClassifer.getInstance();
        EventModel eventModel = new EventModel(model);
        for (IDesc desc : model.getData().getDescriptions(EventRep.getInstance())) {
            IEvent event = (IEvent)desc.getData();
            Tense tense = null;
            Aspect aspect = null;
            if (event.getTense() == Tense.UNSPECIFIED || event.getAspect() == Aspect.UNSPECIFIED) continue;
            eventModel.clear();
            eventModel.getEventModel().setSegments((Collection)event.getEventTokens());
            eventModel.getHeadModel().setSegments((Collection)event.getHeadTokens());
            if (event.getPolarityTokens() != null) {
                eventModel.getPolarityModel().setSegment((Collection)event.getPolarityTokens().getDescs());
            } else {
                eventModel.setPolarityEmpty(true);
            }
            if (event.getModalityTokens() != null) {
                eventModel.getModalityModel().setSegment((Collection)event.getModalityTokens().getDescs());
            } else {
                eventModel.setModalityEmpty(true);
            }
            eventModel.setPOS(event.getPOS());
            classifier.classify(eventModel);
            if (eventModel.getTense() != Tense.UNSPECIFIED && event.getTense() != eventModel.getTense()) {
                tense = eventModel.getTense();
            }
            if (eventModel.getAspect() != Aspect.UNSPECIFIED && event.getAspect() != eventModel.getAspect()) {
                aspect = eventModel.getAspect();
            }
            if (tense == null && aspect == null) continue;
            EntryImpl entry = new EntryImpl((Object)tense, aspect);
            problems.put(desc, (Map.Entry<Tense, Aspect>)entry);
        }
        Iterator i = problems.keySet().iterator();
        while (i.hasNext()) {
            IMetaDataSet checks = ((IDesc)i.next()).getMetaData().get((IMetaRep)CheckMetaRep.getInstance());
            for (IMetaDesc check : checks) {
                if (!((ICheck)check.getData()).getCheck().equals("edu.mit.semantics.event.problem.unexpectedTenseAspect")) continue;
                i.remove();
            }
        }
        if (problems.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        if (this.isCompressing()) {
            result.add((Object)new UnexpectedTenseAspectProblem(problems, this.getID()));
        } else {
            for (Map.Entry e : problems.entrySet()) {
                result.add((Object)new UnexpectedTenseAspectProblem((IDesc)e.getKey(), (Tense)((Object)((Map.Entry)e.getValue()).getKey()), (Aspect)((Object)((Map.Entry)e.getValue()).getValue()), this.getID()));
            }
        }
        return result;
    }
}

