/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event.rules;

import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.event.POS;
import edu.mit.semantics.core.rep.event.problems.NonMatchingTagProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.DescUtils;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.meta.check.ICheck;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckPartOfSpeechRule
extends AbstractBuildRule {
    public static final String ID = CheckPartOfSpeechRule.class.getCanonicalName();

    public CheckPartOfSpeechRule() {
        super(EventRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        NonMatchingTagProblem p;
        if (!model.supports(POSRep.getInstance())) {
            return null;
        }
        DescSet problems = new DescSet(EventRep.getInstance());
        IDescSet posDescs = model.getData().getDescriptions(POSRep.getInstance());
        for (IDesc d : model.getData().getDescriptions(EventRep.getInstance())) {
            IEvent event = (IEvent)d.getData();
            POS expected = event.getPOS();
            if (expected == POS.OTHER || expected == POS.UNSPECIFIED) continue;
            for (IDesc token : event.getHeadTokens().getDescs()) {
                IPosTag tag;
                IDesc tagDesc = DescUtils.getSingleMatch((IHasPosition)token, (IDescSet)posDescs);
                if (tagDesc == null || POS.toPOS((tag = (IPosTag)tagDesc.getData()).getTag()) != expected) continue;
                expected = null;
                break;
            }
            if (expected == null) continue;
            problems.add(d);
        }
        Iterator i = problems.iterator();
        while (i.hasNext()) {
            IMetaDataSet checks = ((IDesc)i.next()).getMetaData().get((IMetaRep)CheckMetaRep.getInstance());
            for (IMetaDesc check : checks) {
                if (!((ICheck)check.getData()).getCheck().equals("edu.mit.semantics.event.problem.nonmatchingTag")) continue;
                i.remove();
            }
        }
        if (problems.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        if (this.isCompressing()) {
            p = new NonMatchingTagProblem((Collection<? extends IDesc>)problems, this.getID());
            p.setCheck("edu.mit.semantics.event.problem.nonmatchingTag");
            result.add((Object)p);
        } else {
            for (IDesc d : problems) {
                p = new NonMatchingTagProblem(d, this.getID());
                p.setCheck("edu.mit.semantics.event.problem.nonmatchingTag");
                result.add((Object)p);
            }
        }
        return result;
    }
}

