/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event.problems;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnspecifiedFeatureProblem
extends StoryProblem {
    public static final String ID = "edu.mit.semantics.core.problem.unspecifiedFeature";

    public UnspecifiedFeatureProblem(IDesc desc, String buildRuleID) {
        this(Collections.singleton(desc), buildRuleID);
    }

    public UnspecifiedFeatureProblem(Collection<? extends IDesc> descs, String buildRuleID) {
        super(EventRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("unspecified event feature");
        this.setSeverity(2);
        this.setDescs(descs);
        IDescSet ds = this.getDescs().getDescriptions(EventRep.getInstance());
        if (ds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setPosition((IHasPosition)ds.first());
        StringBuilder sb = new StringBuilder();
        if (ds.size() == 1) {
            IDesc d = (IDesc)ds.first();
            IEvent event = (IEvent)d.getData();
            sb.append("The event '");
            sb.append(event.getEventTokens().getDisplayText());
            sb.append("' has at least one unspecified feature");
        } else {
            sb.append("There are ");
            sb.append(Integer.toString(ds.size()));
            sb.append(" events with at least one unspecified feature (only first shown)");
        }
        this.setDescription(sb.toString());
    }
}

