/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event.problems;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverusedTokensProblem
extends StoryProblem {
    public static final String ID = "edu.mit.semantics.event.problem.overusedTokens";

    public OverusedTokensProblem(IDesc desc, String buildRuleID, String check) {
        this(Collections.singleton(desc), buildRuleID, check);
    }

    public OverusedTokensProblem(Collection<? extends IDesc> descs, String buildRuleID, String check) {
        super(EventRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("multiply-used tokens");
        this.setSeverity(1);
        this.setRep(EventRep.getInstance());
        this.setDescs(descs);
        IDescSet ds = this.getDescs().getDescriptions(EventRep.getInstance());
        if (ds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setPosition((IHasPosition)ds.first());
        StringBuilder sb = new StringBuilder();
        if (ds.size() == 1) {
            IEvent e = (IEvent)((IDesc)ds.first()).getData();
            sb.append("The event '");
            sb.append(e.getEventTokens().getDisplayText());
            sb.append("' used at least one token in multiple features");
        } else {
            sb.append("There are ");
            sb.append(Integer.toString(ds.size()));
            sb.append(" events that use at least one token in multiple features");
        }
        this.setDescription(sb.toString());
    }
}

