/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event;

import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.event.Aspect;
import edu.mit.semantics.core.rep.event.IFeatureClassifier;
import edu.mit.semantics.core.rep.event.POS;
import edu.mit.semantics.core.rep.event.Tense;
import edu.mit.semantics.core.rep.event.model.IEventModel;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.DescUtils;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.position.IHasPosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventClassifer
implements IFeatureClassifier {
    public static final Set<String> bes = EventClassifer.toSet("'ll", "'m", "'re", "'s", "shall", "am", "are", "be", "been", "being", "is", "was", "were", "will", "wo");
    public static final Set<String> haves = EventClassifer.toSet("had", "has", "have", "'ve", "'s");
    public static final Set<String> dos = EventClassifer.toSet("did", "do", "does");
    public static final Set<String> others = EventClassifer.toSet("going", "to");
    public static final Set<String> negatives = EventClassifer.toSet("neither", "no", "not", "n't");
    public static final Set<String> modals = EventClassifer.toSet("can", "could", "may", "might", "must", "should", "would", "shall", "sha", "ca");
    String[] beStarts = new String[]{"is", "am", "are", "'s", "'m", "'re"};
    String[] wasStarts = new String[]{"was", "were"};
    String[] willStarts = new String[]{"will", "'ll", "wo", "shall"};
    String[] haveStarts = new String[]{"has", "have", "'ve", "'s"};
    String[] doStarts = new String[]{"do", "does"};
    private static EventClassifer instance = null;

    protected static final Set<String> toSet(String ... array) {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(array)));
    }

    public static EventClassifer getInstance() {
        if (instance == null) {
            instance = new EventClassifer();
        }
        return instance;
    }

    protected EventClassifer() {
    }

    @Override
    public void classify(IEventModel model) {
        Map tags;
        POS pos;
        IDescSet posDescs = null;
        if (model.getStoryModel().supports(POSRep.getInstance())) {
            posDescs = model.getStoryModel().getData().getDescriptions(POSRep.getInstance());
        }
        if ((pos = this.classifyPOS(model, tags = DescUtils.getMatchMap((Collection)model.getEventTokens().getDescs(), posDescs))) == null) {
            return;
        }
        this.classifyPolarity(model);
        ISegment modality = this.classifyModality(model);
        if (pos == POS.VERB) {
            if (modality == null) {
                this.classifyNormalVerb(model, tags);
            } else if (this.isHaveToModal((Collection<? extends IDesc>)modality.getDescs())) {
                this.classifyHaveToModalVerb(model, tags);
            } else {
                this.classifyOtherModalVerb(model, tags);
            }
        } else {
            this.classifyNonVerb(model);
        }
    }

    protected final void setTense(IEventModel model, Tense tense) {
        if (model.getTense() == Tense.UNSPECIFIED) {
            model.setTense(tense);
        }
    }

    protected final void setAspect(IEventModel model, Aspect aspect) {
        if (model.getAspect() == Aspect.UNSPECIFIED) {
            model.setAspect(aspect);
        }
    }

    protected POS classifyPOS(IEventModel model, Map<IDesc, IDesc> tags) {
        if (model.getPOS() != POS.UNSPECIFIED) {
            return model.getPOS();
        }
        ISegmentSet head = this.classifyHead(model);
        if (head == null) {
            return null;
        }
        model.setPOS(this.classifyPOS(tags));
        return model.getPOS();
    }

    protected ISegmentSet classifyHead(IEventModel model) {
        if (model.getHeadTokens() != null) {
            return model.getHeadTokens();
        }
        ISegmentSet eventTokens = model.getEventTokens();
        if (eventTokens == null) {
            return null;
        }
        IDesc ingWord = null;
        IStoryData data = model.getStoryModel().getData();
        DescSet tokens = new DescSet(TokenRep.getInstance());
        LinkedList<Segment> segs = new LinkedList<Segment>();
        for (ISegment seg : eventTokens) {
            tokens.clear();
            for (IDesc token : seg.getDescs()) {
                if (EventClassifer.isFunctionWord(token)) {
                    if (this.isForm(token, model, IFeatureClassifier.Form.GERUND)) {
                        ingWord = token;
                    }
                    if (tokens.isEmpty()) continue;
                    segs.add(new Segment((IHasPosition)tokens, tokens.getRep(), data));
                    tokens.clear();
                    continue;
                }
                tokens.add((Object)token);
            }
            if (tokens.isEmpty()) continue;
            segs.add(new Segment((IHasPosition)tokens, tokens.getRep(), data));
        }
        if (segs.isEmpty() && ingWord != null) {
            segs.add(new Segment(ingWord, ingWord.getRep(), data));
        }
        model.getHeadModel().setSegments(segs);
        return model.getEventTokens();
    }

    protected ISegment classifyPolarity(IEventModel model) {
        if (model.getPolarityTokens() != null || model.isPolarityEmpty()) {
            return model.getPolarityTokens();
        }
        IDesc negToken = null;
        for (IDesc d : this.getUnusedTokens(model)) {
            String form = EventClassifer.getNormalizedToken(d);
            if (!negatives.contains(form)) continue;
            negToken = d;
            break;
        }
        if (negToken != null) {
            model.getPolarityModel().setSegment(Collections.singleton(negToken));
            model.setPolarity(false);
        }
        return model.getPolarityTokens();
    }

    protected ISegment classifyModality(IEventModel model) {
        if (model.getModalityTokens() != null || model.isModalityEmpty()) {
            return model.getModalityTokens();
        }
        IDescSet unused = this.getUnusedTokens(model);
        for (IDesc d : unused) {
            IDesc next;
            String form = EventClassifer.getNormalizedToken(d);
            if (modals.contains(form)) {
                model.getModalityModel().setSegment(Collections.singleton(d));
                break;
            }
            if (!haves.contains(form)) continue;
            Iterator i = unused.tailSet(d).iterator();
            if (i.next() != d) {
                throw new IllegalStateException();
            }
            if (!i.hasNext() || !this.isWord(next = (IDesc)i.next(), "to")) continue;
            model.getModalityModel().setSegment(Arrays.asList(d, next));
            break;
        }
        return model.getModalityTokens();
    }

    protected POS classifyPOS(Map<IDesc, IDesc> tokensToTags) {
        POS last = null;
        for (IDesc desc : tokensToTags.values()) {
            if (desc == null) continue;
            IPosTag postag = (IPosTag)desc.getData();
            POS pos = POS.toPOS(postag.getTag());
            if (pos == POS.PREPOSITION) {
                return pos;
            }
            if (pos == null || pos == POS.OTHER) continue;
            last = pos;
        }
        return last;
    }

    protected void classifyNormalVerb(IEventModel model, Map<IDesc, IDesc> tags) {
        ISegmentSet h = this.classifyHead(model);
        if (h == null) {
            return;
        }
        IDescSet head = h.getDescs();
        IDescSet unused = this.getUnusedTokens(model);
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.willStarts, new String[]{"have", "been"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.BOTH);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.willStarts, new String[]{"have", "been", "being"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.BOTH);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.willStarts, new String[]{"have"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.PERFECT);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.willStarts, new String[]{"have", "been"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.PERFECT);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.beStarts, new String[]{"going", "to", "be"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.beStarts, new String[]{"going", "to", "be", "being"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.willStarts, new String[]{"be"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.willStarts, new String[]{"be", "being"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.beStarts, new String[]{"going", "to"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.BASE)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.beStarts, new String[]{"going", "to", "be"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWord((Collection<? extends IDesc>)unused, this.willStarts) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.BASE)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.willStarts, new String[]{"be"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, "had", "been") && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND)) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.BOTH);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, "had", "been", "being") && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.BOTH);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, "had") && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.PERFECT);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, "had", "been") && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.PERFECT);
            return;
        }
        if (this.containsWord((Collection<? extends IDesc>)unused, this.wasStarts) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND)) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.wasStarts, new String[]{"being"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (!EventClassifer.containsFunctionWord((Collection<? extends IDesc>)unused) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWord((Collection<? extends IDesc>)unused, this.wasStarts) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.haveStarts, new String[]{"been"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND) && !this.containsWordSequence((Collection<? extends IDesc>)unused, "to", "have", "been")) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.BOTH);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.haveStarts, new String[]{"been", "being"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.BOTH);
            return;
        }
        if (this.containsWord((Collection<? extends IDesc>)unused, this.haveStarts) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST) && !this.containsWordSequence((Collection<? extends IDesc>)unused, "to", "have")) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.PERFECT);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.haveStarts, new String[]{"been"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.PERFECT);
            return;
        }
        if (this.containsWord((Collection<? extends IDesc>)unused, this.beStarts) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND)) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.beStarts, new String[]{"being"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (!EventClassifer.containsFunctionWord((Collection<? extends IDesc>)unused) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.BASE, IFeatureClassifier.Form.THIRDPERSONSING)) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWord((Collection<? extends IDesc>)unused, this.beStarts) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWord((Collection<? extends IDesc>)unused, dos)) {
            this.classifyEmphaticVerb(model, tags);
        }
        this.classifyNonFiniteVerb(model, tags);
    }

    protected void classifyNonFiniteVerb(IEventModel model, Map<IDesc, IDesc> tags) {
        ISegmentSet h = this.classifyHead(model);
        if (h == null) {
            return;
        }
        IDescSet head = h.getDescs();
        IDescSet unused = this.getUnusedTokens(model);
        if (this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.BASE)) {
            this.setTense(model, Tense.INFINITIVE);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWord((Collection<? extends IDesc>)unused, "be") && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND)) {
            this.setTense(model, Tense.INFINITIVE);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (this.containsWord((Collection<? extends IDesc>)unused, "have") && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.INFINITIVE);
            this.setAspect(model, Aspect.PERFECT);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, "have", "been") && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND)) {
            this.setTense(model, Tense.INFINITIVE);
            this.setAspect(model, Aspect.BOTH);
            return;
        }
        if (unused.isEmpty() && head.size() == 1) {
            if (this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND)) {
                this.setTense(model, Tense.PRESPART);
                this.setAspect(model, Aspect.NONE);
                return;
            }
            if (this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
                this.setTense(model, Tense.PASTPART);
                this.setAspect(model, Aspect.NONE);
                return;
            }
        }
    }

    protected void classifyEmphaticVerb(IEventModel model, Map<IDesc, IDesc> tags) {
        ISegmentSet h = this.classifyHead(model);
        if (h == null) {
            return;
        }
        IDescSet head = h.getDescs();
        IDescSet unused = this.getUnusedTokens(model);
        if (this.containsWord((Collection<? extends IDesc>)unused, this.doStarts) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.BASE)) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWord((Collection<? extends IDesc>)unused, "did") && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.BASE)) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.NONE);
            return;
        }
    }

    protected void classifyHaveToModalVerb(IEventModel model, Map<IDesc, IDesc> tags) {
        ISegmentSet h = this.classifyHead(model);
        if (h == null) {
            return;
        }
        ISegment m = this.classifyModality(model);
        if (m == null) {
            return;
        }
        IDescSet head = h.getDescs();
        IDescSet modal = m.getDescs();
        if (modal.size() < 2) {
            return;
        }
        DescSet nonhead = new DescSet(model.getEventTokens().getDescs());
        nonhead.removeAll((Collection)head);
        if (this.containsWordSequence((Collection<? extends IDesc>)nonhead, this.willStarts, new String[]{"have", "to", "be"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)nonhead, this.willStarts, new String[]{"have", "to"}) && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.BASE)) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)nonhead, "had", "to", "be") && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND)) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)modal, "had", "to") && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.BASE)) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND) && (this.containsWordSequence((Collection<? extends IDesc>)nonhead, "has", "to", "have", "been") || this.containsWordSequence((Collection<? extends IDesc>)nonhead, "have", "to", "have", "been"))) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.BOTH);
            return;
        }
        if (this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST) && (this.containsWordSequence((Collection<? extends IDesc>)nonhead, "has", "to", "have") || this.containsWordSequence((Collection<? extends IDesc>)nonhead, "have", "to", "have"))) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.PERFECT);
            return;
        }
        if (this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND) && (this.containsWordSequence((Collection<? extends IDesc>)nonhead, "has", "to", "be") || this.containsWordSequence((Collection<? extends IDesc>)nonhead, "have", "to", "be"))) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.BASE) && (this.containsWordSequence((Collection<? extends IDesc>)modal, "has", "to") || this.containsWordSequence((Collection<? extends IDesc>)modal, "have", "to"))) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.NONE);
            return;
        }
    }

    protected void classifyOtherModalVerb(IEventModel model, Map<IDesc, IDesc> tags) {
        ISegmentSet h = this.classifyHead(model);
        if (h == null) {
            return;
        }
        IDescSet head = h.getDescs();
        IDescSet unused = this.getUnusedTokens(model);
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, "have", "been") && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND)) {
            this.setTense(model, Tense.NONE);
            this.setAspect(model, Aspect.BOTH);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, "have") && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.PAST)) {
            this.setTense(model, Tense.NONE);
            this.setAspect(model, Aspect.PERFECT);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, "be") && this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.GERUND)) {
            this.setTense(model, Tense.NONE);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (this.containsForm((Collection<? extends IDesc>)head, tags, IFeatureClassifier.Form.BASE)) {
            this.setTense(model, Tense.NONE);
            this.setAspect(model, Aspect.NONE);
            return;
        }
    }

    protected void classifyNonVerb(IEventModel model) {
        IDescSet unused = this.getUnusedTokens(model);
        for (IDesc d : unused) {
            if (!bes.contains(EventClassifer.getNormalizedToken(d))) continue;
            this.classifyCopular(model);
            return;
        }
        this.setTense(model, Tense.NONE);
        this.setAspect(model, Aspect.NONE);
    }

    protected void classifyCopular(IEventModel model) {
        IDescSet unused = this.getUnusedTokens(model);
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.beStarts, new String[]{"being"})) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (this.containsWord((Collection<? extends IDesc>)unused, this.beStarts)) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.wasStarts, new String[]{"being"})) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.PROGRESSIVE);
            return;
        }
        if (this.containsWord((Collection<? extends IDesc>)unused, this.wasStarts)) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, "will", "be")) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.NONE);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, "will", "have", "been")) {
            this.setTense(model, Tense.FUTURE);
            this.setAspect(model, Aspect.PERFECT);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, this.haveStarts, new String[]{"been"})) {
            this.setTense(model, Tense.PRESENT);
            this.setAspect(model, Aspect.PERFECT);
            return;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, "had", "been")) {
            this.setTense(model, Tense.PAST);
            this.setAspect(model, Aspect.PERFECT);
            return;
        }
    }

    protected final IDesc getTag(IDesc token, IEventModel model) {
        IStoryData data = model.getStoryModel().getData();
        IDescSet posDescs = data.supports(POSRep.getInstance()) ? data.getDescriptions(POSRep.getInstance()) : null;
        return posDescs == null ? null : DescUtils.getSingleMatch((IHasPosition)token, (IDescSet)posDescs);
    }

    protected final IDescSet getUnusedTokens(IEventModel model) {
        ISegment seg;
        ISegmentSet segs = model.getEventTokens();
        if (segs == null) {
            return null;
        }
        DescSet all = new DescSet(segs.getDescs());
        segs = model.getHeadTokens();
        if (segs != null) {
            all.removeAll((Collection)segs.getDescs());
        }
        if ((seg = model.getModalityTokens()) != null) {
            all.removeAll((Collection)seg.getDescs());
        }
        if ((seg = model.getPolarityTokens()) != null) {
            all.removeAll((Collection)seg.getDescs());
        }
        if ((seg = model.getCardinalityTokens()) != null) {
            all.removeAll((Collection)seg.getDescs());
        }
        return all;
    }

    protected final boolean isWord(IDesc desc, String ... words) {
        return this.isWord(desc, Arrays.asList(words));
    }

    protected final boolean isWord(IDesc desc, Collection<? extends String> words) {
        String token = EventClassifer.getNormalizedToken(desc);
        for (String string : words) {
            if (!string.equals(token)) continue;
            return true;
        }
        return false;
    }

    protected final boolean containsWord(Collection<? extends IDesc> ds, String ... words) {
        return this.containsWord(ds, Arrays.asList(words));
    }

    protected final boolean containsWord(Collection<? extends IDesc> ds, Collection<? extends String> words) {
        for (IDesc iDesc : ds) {
            if (!this.isWord(iDesc, words)) continue;
            return true;
        }
        return false;
    }

    protected final boolean containsWordSequence(Collection<? extends IDesc> ds, String ... forms) {
        int i = 0;
        for (IDesc iDesc : ds) {
            if (!this.isWord(iDesc, forms[i]) || forms.length != ++i) continue;
            return true;
        }
        return false;
    }

    protected final boolean containsWordSequence(Collection<? extends IDesc> ds, String[] first, String ... forms) {
        int i = 0;
        boolean foundFirst = false;
        block0: for (IDesc iDesc : ds) {
            if (!foundFirst) {
                String[] stringArray = first;
                int n = first.length;
                int n2 = 0;
                while (n2 < n) {
                    String form = stringArray[n2];
                    if (this.isWord(iDesc, form)) {
                        foundFirst = true;
                        continue block0;
                    }
                    ++n2;
                }
                continue;
            }
            if (!this.isWord(iDesc, forms[i]) || forms.length != ++i) continue;
            return true;
        }
        return false;
    }

    protected final boolean isForm(IDesc tokenDesc, IEventModel model, IFeatureClassifier.Form ... forms) {
        IDesc tagDesc = this.getTag(tokenDesc, model);
        IPosTag tag = tagDesc == null ? null : (IPosTag)tagDesc.getData();
        String tagstr = tag == null ? null : tag.getTag().getTagString();
        IFeatureClassifier.Form[] formArray = forms;
        int n = forms.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureClassifier.Form form = formArray[n2];
            if (form.getTagStrings().contains(tagstr)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected final boolean containsForm(Collection<? extends IDesc> descs, Map<IDesc, IDesc> tags, IFeatureClassifier.Form ... forms) {
        for (IDesc iDesc : descs) {
            IDesc tagDesc = tags.get(iDesc);
            IPosTag tag = tagDesc == null ? null : (IPosTag)tagDesc.getData();
            String tagstr = tag == null ? null : tag.getTag().getTagString();
            IFeatureClassifier.Form[] formArray = forms;
            int n = forms.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureClassifier.Form form = formArray[n2];
                if (form.getTagStrings().contains(tagstr)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected final boolean isHaveToModal(Collection<? extends IDesc> modality) {
        if (modality.size() != 2) {
            return false;
        }
        Iterator<? extends IDesc> i = modality.iterator();
        String form = EventClassifer.getNormalizedToken(i.next());
        if (!haves.contains(form)) {
            return false;
        }
        return this.isWord(i.next(), "to");
    }

    protected final boolean containsInfinitiveTo(IEventModel model) {
        IDescSet unused = this.getUnusedTokens(model);
        if (!this.containsWord((Collection<? extends IDesc>)unused, "to")) {
            return false;
        }
        if (this.containsWordSequence((Collection<? extends IDesc>)unused, "to", "be")) {
            return false;
        }
        return !this.containsWordSequence((Collection<? extends IDesc>)unused, "is", "going", "to");
    }

    public static String getNormalizedToken(IDesc desc) {
        IToken token = (IToken)desc.getData();
        return token.getSurface().toLowerCase();
    }

    public static boolean containsFunctionWord(Collection<? extends IDesc> ds) {
        for (IDesc iDesc : ds) {
            if (!EventClassifer.isFunctionWord(iDesc)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFunctionWord(IDesc desc) {
        String form = EventClassifer.getNormalizedToken(desc);
        if (bes.contains(form)) {
            return true;
        }
        if (haves.contains(form)) {
            return true;
        }
        if (dos.contains(form)) {
            return true;
        }
        if (others.contains(form)) {
            return true;
        }
        if (negatives.contains(form)) {
            return true;
        }
        return modals.contains(form);
    }
}

