/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event;

import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.event.Aspect;
import edu.mit.semantics.core.rep.event.EventClass;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.event.POS;
import edu.mit.semantics.core.rep.event.Tense;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Data;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IHasRep;
import java.util.Collections;

public class Event
implements IEvent {
    private final EventClass eventClass;
    private final ISegmentSet eventTokens;
    private final ISegmentSet headTokens;
    private final POS pos;
    private final Tense tense;
    private final Aspect aspect;
    private final boolean polarity;
    private final ISegment polTokens;
    private final int cardinality;
    private final ISegment cardTokens;
    private final ISegment modeTokens;

    public Event(EventClass eventClass, ISegment event, POS pos, Tense tense, Aspect aspect) {
        this(eventClass, (ISegmentSet)new SegmentSet(Collections.singleton(event)), (ISegmentSet)new SegmentSet(Collections.singleton(event)), pos, tense, aspect, true, null, 1, null, null);
    }

    public Event(EventClass eventClass, ISegmentSet eventTokens, ISegmentSet headTokens, POS pos, Tense tense, Aspect aspect, boolean polarity, ISegment polTokens, int cardinality, ISegment cardTokens, ISegment modeTokens) {
        if (eventClass == null) {
            throw new NullPointerException();
        }
        if (eventTokens == null) {
            throw new NullPointerException();
        }
        if (headTokens == null) {
            throw new NullPointerException();
        }
        if (pos == null) {
            throw new NullPointerException();
        }
        if (tense == null) {
            throw new NullPointerException();
        }
        if (aspect == null) {
            throw new NullPointerException();
        }
        if (cardinality < 0) {
            throw new IllegalArgumentException();
        }
        if (!TokenRep.getInstance().isType((IHasRep)headTokens)) {
            throw new IllegalArgumentException();
        }
        if (!TokenRep.getInstance().isType((IHasRep)eventTokens)) {
            throw new IllegalArgumentException();
        }
        if (polTokens != null && !TokenRep.getInstance().isType((IHasRep)polTokens)) {
            throw new IllegalArgumentException();
        }
        if (modeTokens != null && !TokenRep.getInstance().isType((IHasRep)modeTokens)) {
            throw new IllegalArgumentException();
        }
        if (cardTokens != null && !TokenRep.getInstance().isType((IHasRep)cardTokens)) {
            throw new IllegalArgumentException();
        }
        this.eventClass = eventClass;
        this.eventTokens = eventTokens;
        this.headTokens = headTokens;
        this.pos = pos;
        this.tense = tense;
        this.aspect = aspect;
        this.polarity = polarity;
        this.polTokens = polTokens;
        this.modeTokens = modeTokens;
        this.cardinality = cardinality;
        this.cardTokens = cardTokens;
    }

    public EventClass getEventClass() {
        return this.eventClass;
    }

    public ISegmentSet getEventTokens() {
        return this.eventTokens;
    }

    public ISegmentSet getHeadTokens() {
        return this.headTokens;
    }

    public POS getPOS() {
        return this.pos;
    }

    public Tense getTense() {
        return this.tense;
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public boolean getPolarity() {
        return this.polarity;
    }

    public ISegment getPolarityTokens() {
        return this.polTokens;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public ISegment getCardinalityTokens() {
        return this.cardTokens;
    }

    public ISegment getModalityTokens() {
        return this.modeTokens;
    }

    public IHasPosition calculatePosition() {
        return new SimplePosition((IHasPosition)this.eventTokens);
    }

    public IHasPosition getDisplayPosition() {
        return new SimplePosition((IHasPosition)this.eventTokens);
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        ISegmentSet newEventTokens = (ISegmentSet)this.eventTokens.recalculate(container, model);
        if (newEventTokens == null) {
            return null;
        }
        ISegmentSet newHeadTokens = (ISegmentSet)this.headTokens.recalculate(container, model);
        if (newHeadTokens == null) {
            return null;
        }
        ISegment newPolTokens = this.polTokens == null ? null : (ISegment)this.polTokens.recalculate(container, model);
        ISegment newModeTokens = this.modeTokens == null ? null : (ISegment)this.modeTokens.recalculate(container, model);
        ISegment newCardTokens = this.cardTokens == null ? null : (ISegment)this.cardTokens.recalculate(container, model);
        boolean changed = false;
        changed |= newEventTokens != this.eventTokens;
        changed |= newHeadTokens != this.headTokens;
        changed |= newPolTokens != this.polTokens;
        changed |= newModeTokens != this.modeTokens;
        if (!(changed |= newCardTokens != this.cardTokens)) {
            return this;
        }
        return new Event(this.eventClass, newEventTokens, newHeadTokens, this.pos, this.tense, this.aspect, this.polarity, newPolTokens, this.cardinality, newCardTokens, newModeTokens);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (this == tgtData) {
            return true;
        }
        if (!IEvent.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        IEvent tgtEvt = (IEvent)tgtData;
        if (this.polarity != tgtEvt.getPolarity()) {
            return false;
        }
        if (this.cardinality != tgtEvt.getCardinality()) {
            return false;
        }
        if (!this.eventClass.equals((Object)tgtEvt.getEventClass())) {
            return false;
        }
        if (!this.pos.equals((Object)tgtEvt.getPOS())) {
            return false;
        }
        if (!this.tense.equals((Object)tgtEvt.getTense())) {
            return false;
        }
        if (!this.aspect.equals((Object)tgtEvt.getAspect())) {
            return false;
        }
        if (!Data.equals((IData)this.eventTokens, (IData)tgtEvt.getEventTokens(), (IAlignedStoryModel)model)) {
            return false;
        }
        if (!Data.equals((IData)this.headTokens, (IData)tgtEvt.getHeadTokens(), (IAlignedStoryModel)model)) {
            return false;
        }
        if (!Data.equals((IData)this.cardTokens, (IData)tgtEvt.getCardinalityTokens(), (IAlignedStoryModel)model)) {
            return false;
        }
        if (!Data.equals((IData)this.polTokens, (IData)tgtEvt.getPolarityTokens(), (IAlignedStoryModel)model)) {
            return false;
        }
        return Data.equals((IData)this.modeTokens, (IData)tgtEvt.getModalityTokens(), (IAlignedStoryModel)model);
    }
}

