/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.context;

import edu.mit.jpropbank.frames.IRole;
import edu.mit.jwi.item.ISynset;
import edu.mit.semantics.core.rep.context.IContextRole;

public class ContextRole
implements IContextRole {
    private final IContextRole.RoleType type;
    private final IRole role;
    private final ISynset synset;

    public ContextRole(IRole role) {
        this(IContextRole.RoleType.PROPBANK, null, role);
    }

    public ContextRole(ISynset synset) {
        this(IContextRole.RoleType.WORDNET, synset, null);
    }

    ContextRole(IContextRole.RoleType type, ISynset synset, IRole role) {
        if (type == null) {
            throw new NullPointerException();
        }
        switch (type) {
            case WORDNET: {
                if (synset != null) break;
                throw new NullPointerException();
            }
            case PROPBANK: {
                if (role != null) break;
                throw new NullPointerException();
            }
        }
        this.type = type;
        this.role = role;
        this.synset = synset;
    }

    public IContextRole.RoleType getType() {
        return this.type;
    }

    public ISynset getWordnetRole() {
        return this.synset;
    }

    public IRole getPropbankRole() {
        return this.role;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextRole other = (ContextRole)obj;
        if (this.role == null ? other.role != null : !this.role.equals(other.role)) {
            return false;
        }
        return !(this.synset == null ? other.synset != null : !this.synset.equals(other.synset));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.synset == null ? 0 : this.synset.hashCode());
        return result;
    }
}

