/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.propbank;

import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.jpropbank.frames.handlers.FramesetHandler;
import edu.mit.semantics.core.SemanticsPlugin;
import edu.mit.story.core.util.IHasLifecycle;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameManager
implements IHasLifecycle {
    private static final Pattern underdashPat = Pattern.compile("_+");
    private final URL frameFile;
    private SortedMap<String, List<IRoleset>> predicates;
    private SortedMap<String, IRoleset> rolesets;

    public FrameManager(URL frameFile) {
        if (frameFile == null) {
            throw new NullPointerException();
        }
        this.frameFile = frameFile;
    }

    public void init() {
        InputStream is = null;
        try {
            try {
                List<IRoleset> list;
                InputSource input = new InputSource(new BufferedInputStream(this.frameFile.openStream()));
                XMLReader parser = XMLReaderFactory.createXMLReader();
                parser.setFeature("http://xml.org/sax/features/namespaces", false);
                parser.setFeature("http://xml.org/sax/features/validation", false);
                parser.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                FramesetHandler handler = new FramesetHandler(parser);
                parser.setContentHandler((ContentHandler)handler);
                parser.parse(input);
                TreeMap ps = new TreeMap();
                TreeMap<String, IRoleset> rs = new TreeMap<String, IRoleset>();
                for (IRoleset iRoleset : handler.getRolesets()) {
                    List<String> lemmas = this.getIndexLemmas(iRoleset.getLemma());
                    for (String lemma : lemmas) {
                        list = (List)ps.get(lemma);
                        if (list == null) {
                            list = new LinkedList();
                            ps.put(lemma, list);
                        }
                        list.add(iRoleset);
                    }
                    rs.put(iRoleset.getID(), iRoleset);
                }
                for (Map.Entry entry : ps.entrySet()) {
                    list = (ArrayList)entry.getValue();
                    list = new ArrayList(list);
                    entry.setValue(Collections.unmodifiableList(list));
                }
                this.predicates = Collections.unmodifiableSortedMap(ps);
                this.rolesets = Collections.unmodifiableSortedMap(rs);
            }
            catch (Exception e) {
                Status status = new Status(4, SemanticsPlugin.getDefault().getBundle().getSymbolicName(), "Error reading frame xml file", (Throwable)e);
                SemanticsPlugin.getDefault().getLog().log((IStatus)status);
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e2) {
                    Status status2 = new Status(4, SemanticsPlugin.getDefault().getBundle().getSymbolicName(), "Error closing frame xml file", (Throwable)e2);
                    SemanticsPlugin.getDefault().getLog().log((IStatus)status2);
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                Status status = new Status(4, SemanticsPlugin.getDefault().getBundle().getSymbolicName(), "Error closing frame xml file", (Throwable)e);
                SemanticsPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    protected List<String> getIndexLemmas(String lemma) {
        LinkedList<String> result = new LinkedList<String>();
        result.add(lemma);
        String[] stringArray = underdashPat.split(lemma);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String lem = stringArray[n2];
            result.add(lem);
            ++n2;
        }
        return result;
    }

    public boolean isInitialized() {
        return this.predicates != null;
    }

    public void dispose() {
        this.predicates = null;
        this.rolesets = null;
    }

    public SortedMap<String, List<IRoleset>> getPredicates() {
        return this.predicates;
    }

    public SortedMap<String, IRoleset> getRoleSets() {
        return this.rolesets;
    }
}

