/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.valence.IEventValence;
import edu.mit.semantics.core.rep.valence.ValenceRep;
import edu.mit.semantics.ui.SemanticsUIPlugin;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class ValenceLabelProvider
extends StoryModelLabelProvider {
    protected Image valImg;

    public ValenceLabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public StyledString getStyledText(Object element) {
        Object data = element;
        long id = -1L;
        if (data instanceof IDesc) {
            IDesc desc;
            IDesc iDesc = desc = data instanceof IDesc ? (IDesc)data : null;
            if (ValenceRep.getInstance().isType((IHasRep)desc)) {
                id = desc.getID();
                data = desc.getData();
            }
        }
        if (data instanceof IEventValence) {
            IEventValence eval = (IEventValence)data;
            IEvent event = (IEvent)eval.getEvent().getData();
            StyledString result = new StyledString();
            result.append(event.getEventTokens().getDisplayText());
            result.append(" - ");
            result.append(eval.getValence().getName(), StyledString.COUNTER_STYLER);
            ValenceLabelProvider.appendID((StyledString)result, (long)id);
            if (element instanceof IDesc) {
                ValenceLabelProvider.appendMergeTags((StyledString)result, (IDesc)((IDesc)element));
            }
            return result;
        }
        return super.getStyledText(data);
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc && ValenceRep.getInstance().isType((IHasRep)((IDesc)element))) {
            return this.getArchetypeImage();
        }
        return super.getImage(element);
    }

    protected Image getArchetypeImage() {
        if (this.valImg == null) {
            this.valImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/valence.png");
        }
        return this.valImg;
    }
}

