/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.timelink.IRelType;
import edu.mit.semantics.core.rep.timelink.ITimeLink;
import edu.mit.semantics.core.rep.timelink.TimeLinkRep;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.semantics.ui.SemanticsUIPlugin;
import edu.mit.semantics.ui.label.Timex3LabelProvider;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class TimeLinkLabelProvider
extends StoryModelLabelProvider {
    protected Image linkImg;
    protected Image eventImg;
    protected Image signalImg;
    protected Image typeImg;
    protected DelegatingStyledCellLabelProvider.IStyledLabelProvider timexLabelProvider;

    public TimeLinkLabelProvider(IStoryEditor editor) {
        super(editor);
        this.timexLabelProvider = new Timex3LabelProvider(editor);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof IDesc && TimeLinkRep.getInstance().isType((IHasRep)((IDesc)element))) {
            IDesc d = (IDesc)element;
            ITimeLink link = (ITimeLink)d.getData();
            StyledString result = new StyledString();
            if (link.getSignal() != null) {
                result.append(link.getSignal().getDisplayText());
            } else {
                result.append(link.getRelationType().getName());
            }
            result = TimeLinkLabelProvider.appendID((StyledString)result, (long)d.getID());
            return TimeLinkLabelProvider.appendMergeTags((StyledString)result, (IDesc)d);
        }
        if (element instanceof ITimeLink) {
            ITimeLink link = (ITimeLink)element;
            StyledString result = new StyledString();
            if (link.getSignal() != null) {
                result.append(link.getSignal().getDisplayText());
            } else {
                result.append(link.getRelationType().getName());
            }
            return result;
        }
        if (element instanceof IDesc && EventRep.getInstance().isType((IHasRep)((IDesc)element))) {
            IDesc d = (IDesc)element;
            IEvent e = (IEvent)d.getData();
            StyledString result = new StyledString();
            result.append(e.getEventTokens().getDisplayText());
            result.append(" (", StyledString.COUNTER_STYLER);
            result.append(e.getEventClass().getName(), StyledString.COUNTER_STYLER);
            result.append(')', StyledString.COUNTER_STYLER);
            return TimeLinkLabelProvider.appendID((StyledString)result, (long)d.getID());
        }
        if (element instanceof IDesc && Timex3Rep.getInstance().isType((IHasRep)((IDesc)element))) {
            return this.timexLabelProvider.getStyledText(element);
        }
        if (element instanceof IEvent) {
            IEvent e = (IEvent)element;
            StyledString result = new StyledString();
            result.append(e.getEventTokens().getDisplayText());
            return result;
        }
        if (element instanceof ISegment) {
            ISegment segment = (ISegment)element;
            StyledString result = new StyledString();
            result.append(segment.getDisplayText());
            result.append(" (signal)", StyledString.DECORATIONS_STYLER);
            return result;
        }
        if (element instanceof IRelType) {
            IRelType type = (IRelType)element;
            StyledString result = new StyledString();
            result.append(type.getType().getName());
            result.append(" : ", StyledString.DECORATIONS_STYLER);
            result.append(type.getName());
            result.append(" (type)", StyledString.DECORATIONS_STYLER);
            return result;
        }
        return super.getStyledText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc && TimeLinkRep.getInstance().isType((IHasRep)((IDesc)element))) {
            return this.getLinkImage();
        }
        if (element instanceof IDesc && EventRep.getInstance().isType((IHasRep)((IDesc)element))) {
            return this.getEventImage();
        }
        if (element instanceof IDesc && Timex3Rep.getInstance().isType((IHasRep)((IDesc)element))) {
            return this.timexLabelProvider.getImage(element);
        }
        if (element instanceof IEvent) {
            return this.getEventImage();
        }
        if (element instanceof ITimeLink) {
            return this.getLinkImage();
        }
        if (element instanceof ISegment) {
            return this.getSignalImage();
        }
        if (element instanceof IRelType) {
            return this.getTypeImage();
        }
        return super.getImage(element);
    }

    protected Image getLinkImage() {
        if (this.linkImg == null) {
            this.linkImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/timelink.gif");
        }
        return this.linkImg;
    }

    protected Image getEventImage() {
        if (this.eventImg == null) {
            this.eventImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/event.gif");
        }
        return this.eventImg;
    }

    protected Image getSignalImage() {
        if (this.signalImg == null) {
            this.signalImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/verb.gif");
        }
        return this.signalImg;
    }

    protected Image getTypeImage() {
        if (this.typeImg == null) {
            this.typeImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/properties.gif");
        }
        return this.typeImg;
    }
}

