/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.jpropbank.frames.IRole;
import edu.mit.jpropbank.frames.IRoleset;
import java.util.Iterator;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class RolesetDisplayLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public StyledString getStyledText(Object element) {
        if (element instanceof IRoleset) {
            return this.getStyledText((IRoleset)element);
        }
        if (element instanceof IRole) {
            return this.getStyledText((IRole)element);
        }
        return new StyledString(element.toString());
    }

    protected StyledString getStyledText(IRoleset roleset) {
        StyledString result = new StyledString();
        Iterator i = roleset.getRoles().iterator();
        while (i.hasNext()) {
            IRole role = (IRole)i.next();
            result.append(" - ");
            result.append(role.getLabel());
            if (role.getFeature().length() > 0) {
                result.append('-');
                result.append(role.getFeature());
            }
            result.append(' ');
            result.append(role.getDescription(), StyledString.COUNTER_STYLER);
            if (!i.hasNext()) continue;
            result.append("\n");
        }
        return result;
    }

    protected StyledString getStyledText(IRole role) {
        StyledString result = new StyledString();
        result.append(role.getLabel());
        if (role.getFeature().length() > 0) {
            result.append('-');
            result.append(role.getFeature());
        }
        result.append(" - ");
        result.append(role.getDescription(), StyledString.COUNTER_STYLER);
        return result;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        StyledString result = this.getStyledText(element);
        if (result == null) {
            return "";
        }
        return result.toString();
    }
}

