/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.jpropbank.frames.IExample;
import edu.mit.jpropbank.frames.IRole;
import edu.mit.jpropbank.frames.IRoleset;
import java.util.Comparator;
import org.eclipse.jface.viewers.LabelProvider;

public class RoleSetLabelProvider
extends LabelProvider {
    private static RoleSetLabelProvider instance = null;

    public static RoleSetLabelProvider getInstance() {
        if (instance == null) {
            instance = new RoleSetLabelProvider();
        }
        return instance;
    }

    protected RoleSetLabelProvider() {
    }

    public String getText(Object element) {
        if (element instanceof IRoleset) {
            IRoleset roles = (IRoleset)element;
            StringBuilder sb = new StringBuilder();
            sb.append(roles.getLemma());
            sb.append(" - ");
            sb.append(roles.getName());
            sb.append(" (");
            sb.append(roles.getID());
            sb.append(')');
            return sb.toString();
        }
        if (element instanceof IRole) {
            IRole role = (IRole)element;
            StringBuilder sb = new StringBuilder();
            sb.append(role.getDescription());
            sb.append(" (");
            sb.append(role.getLabel());
            if (role.getFeature().length() > 0) {
                sb.append('-');
                sb.append(role.getFeature());
            }
            sb.append(')');
            return sb.toString();
        }
        return super.getText(element);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExampleComparator
    implements Comparator<IExample> {
        protected ExampleComparator() {
        }

        @Override
        public int compare(IExample o1, IExample o2) {
            return Double.compare(o1.getText().length(), o2.getText().length());
        }
    }
}

