/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.jverbnet.data.IThematicRole;
import edu.mit.jverbnet.data.IVerbClass;
import edu.mit.jverbnet.data.selection.SemRestrType;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleDisplayLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static RoleDisplayLabelProvider instance = null;

    public static RoleDisplayLabelProvider getInstance() {
        if (instance == null) {
            instance = new RoleDisplayLabelProvider();
        }
        return instance;
    }

    protected RoleDisplayLabelProvider() {
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof IVerbClass) {
            return this.getStyledText((IVerbClass)element);
        }
        if (element instanceof IThematicRole) {
            return this.getStyledText((IThematicRole)element);
        }
        return new StyledString(element.toString());
    }

    protected StyledString getStyledText(IVerbClass verb) {
        LinkedList<IVerbClass> ancestors = new LinkedList<IVerbClass>();
        IVerbClass parent = verb;
        while (parent != null) {
            ancestors.addFirst(parent);
            parent = parent.getParent();
        }
        StyledString result = new StyledString();
        for (IVerbClass ancestor : ancestors) {
            for (IThematicRole role : ancestor.getThematicRoles()) {
                result.append(this.getStyledText(role)).append("\n\n");
            }
        }
        return result;
    }

    protected StyledString getStyledText(IThematicRole role) {
        StyledString result = new StyledString();
        result.append(role.getType().getID());
        result.append(" (");
        Map rs = role.getSelRestrictions().getTypeRestrictions();
        if (rs.isEmpty()) {
            result.append("no restrictions");
        }
        Iterator i = rs.entrySet().iterator();
        while (i.hasNext()) {
            result.append(this.getStyledText(i.next()));
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        result.append(")");
        return result;
    }

    protected StyledString getStyledText(Map.Entry<SemRestrType, Boolean> r) {
        StyledString result = new StyledString();
        result.append(r.getValue() != false ? "+" : "-");
        result.append(r.getKey().getID());
        return result;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        StyledString result = this.getStyledText(element);
        if (result == null) {
            return "";
        }
        return result.toString();
    }
}

