/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.jverbnet.data.IMember;
import edu.mit.jverbnet.data.IVerbClass;
import edu.mit.jverbnet.data.IWordnetKey;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class MemberDisplayLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static MemberDisplayLabelProvider instance = null;

    public static MemberDisplayLabelProvider getInstance() {
        if (instance == null) {
            instance = new MemberDisplayLabelProvider();
        }
        return instance;
    }

    protected MemberDisplayLabelProvider() {
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof IVerbClass) {
            return this.getStyledText((IVerbClass)element);
        }
        return new StyledString(element.toString());
    }

    protected StyledString getStyledText(IVerbClass verb) {
        StyledString result = new StyledString();
        for (IMember member : verb.getMembers()) {
            for (IWordnetKey key : member.getWordnetTypes().keySet()) {
                result.append(key.toString()).append('\n');
            }
        }
        return result;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        StyledString result = this.getStyledText(element);
        if (result == null) {
            return "";
        }
        return result.toString();
    }
}

