/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.discourse.ui.label.RefExpLabelProvider;
import edu.mit.jpropbank.frames.IRole;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWord;
import edu.mit.semantics.core.rep.context.ContextRelationRep;
import edu.mit.semantics.core.rep.context.IContextArg;
import edu.mit.semantics.core.rep.context.IContextRelation;
import edu.mit.semantics.core.rep.context.IContextRole;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.ui.label.EventLabelProvider;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import java.util.Iterator;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class ContextRelationLabelProvider
extends StoryModelLabelProvider {
    private Image relImg;
    private final EventLabelProvider eventLP;
    private final RefExpLabelProvider refLP;

    public ContextRelationLabelProvider(IStoryEditor editor) {
        super(editor);
        this.eventLP = new EventLabelProvider(editor);
        this.refLP = new RefExpLabelProvider(editor);
    }

    public StyledString getStyledText(Object element) {
        Object data = element;
        long id = -1L;
        if (data instanceof IDesc) {
            IDesc desc = (IDesc)data;
            if (EventRep.getInstance().isType((IHasRep)desc)) {
                return this.eventLP.getStyledText(desc);
            }
            if (RefExpRep.getInstance().isType((IHasRep)desc)) {
                return this.refLP.getStyledText((Object)desc);
            }
            id = desc.getID();
            data = desc.getData();
        }
        if (data instanceof IContextRelation) {
            IContextRelation rel = (IContextRelation)data;
            StyledString result = new StyledString();
            if (rel.getSignal() == null) {
                result.append("(no signal)");
            } else {
                result.append(rel.getSignal().getDisplayText());
            }
            ContextRelationLabelProvider.appendID((StyledString)result, (long)id);
            if (element instanceof IDesc) {
                ContextRelationLabelProvider.appendMergeTags((StyledString)result, (IDesc)((IDesc)element));
            }
            return result;
        }
        if (StoryEditorContentProvider.isElement((Object)data, IContextArg.class, (int)1)) {
            boolean showDepth;
            StoryEditorContentProvider.Element e = (StoryEditorContentProvider.Element)element;
            IContextArg arg = (IContextArg)e.getElement();
            StyledString result = new StyledString();
            result.append(ContextRelationLabelProvider.getRoleName(arg.getRole()));
            result.append(" ");
            if (EventRep.getInstance().isType((IHasRep)arg.getFiller())) {
                result.append(this.eventLP.getStyledText(arg.getFiller()));
            } else if (RefExpRep.getInstance().isType((IHasRep)arg.getFiller())) {
                result.append(this.refLP.getStyledText((Object)arg.getFiller()));
            }
            boolean showGroup = arg.getExclusionGroup() > 0;
            boolean bl = showDepth = arg.getDepth() > 0;
            if (showGroup || showDepth) {
                result.append(" [", StyledString.COUNTER_STYLER);
                if (arg.getExclusionGroup() == 1) {
                    result.append("head", StyledString.COUNTER_STYLER);
                } else if (showGroup) {
                    result.append("group=", StyledString.COUNTER_STYLER);
                    result.append(Integer.toString(arg.getExclusionGroup()), StyledString.COUNTER_STYLER);
                    if (showDepth) {
                        result.append(", ", StyledString.COUNTER_STYLER);
                    }
                }
                if (arg.getDepth() == 1) {
                    result.append("applies-to-constituents", StyledString.COUNTER_STYLER);
                } else if (showDepth) {
                    result.append("depth=", StyledString.COUNTER_STYLER);
                    result.append(Integer.toString(arg.getDepth()), StyledString.COUNTER_STYLER);
                }
                result.append(']', StyledString.COUNTER_STYLER);
            }
            return result;
        }
        return super.getStyledText(data);
    }

    public static StyledString getRoleName(IContextRole role) {
        StyledString sb = new StyledString();
        switch (role.getType()) {
            case UNKNOWN: {
                sb.append(role.getType().getName());
                break;
            }
            case NONE: {
                sb.append(role.getType().getName());
                break;
            }
            case WORDNET: {
                Iterator i = role.getWordnetRole().getWords().iterator();
                while (i.hasNext()) {
                    sb.append(((IWord)i.next()).getLemma());
                    if (!i.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(" (", StyledString.COUNTER_STYLER);
                sb.append(((ISynsetID)role.getWordnetRole().getID()).toString(), StyledString.COUNTER_STYLER);
                sb.append(')', StyledString.COUNTER_STYLER);
                break;
            }
            case PROPBANK: {
                IRole pbRole = role.getPropbankRole();
                sb.append(pbRole.getDescription());
                sb.append(" (", StyledString.COUNTER_STYLER);
                sb.append(pbRole.getRoleset().getID(), StyledString.COUNTER_STYLER);
                sb.append('-', StyledString.COUNTER_STYLER);
                sb.append(pbRole.getLabel(), StyledString.COUNTER_STYLER);
                if (pbRole.getFeature().length() > 0) {
                    sb.append('-', StyledString.COUNTER_STYLER);
                    sb.append(pbRole.getFeature(), StyledString.COUNTER_STYLER);
                }
                sb.append(')', StyledString.COUNTER_STYLER);
            }
        }
        return sb;
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc && ContextRelationRep.getInstance().isType((IHasRep)((IDesc)element))) {
            return this.getRelationImg();
        }
        if (element instanceof IContextRelation) {
            return this.getRelationImg();
        }
        if (StoryEditorContentProvider.isElement((Object)element, IContextArg.class, (int)1)) {
            StoryEditorContentProvider.Element e = (StoryEditorContentProvider.Element)element;
            IContextArg arg = (IContextArg)e.getElement();
            if (EventRep.getInstance().isType((IHasRep)arg.getFiller())) {
                return this.eventLP.getImage(arg.getFiller());
            }
            if (RefExpRep.getInstance().isType((IHasRep)arg.getFiller())) {
                return this.refLP.getImage((Object)arg.getFiller());
            }
        }
        if (element instanceof ISegmentSet) {
            return this.eventLP.getFeatureImage();
        }
        return super.getImage(element);
    }

    public Image getRelationImg() {
        if (this.relImg == null) {
            this.relImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/relation.gif");
        }
        return this.relImg;
    }
}

