/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.discourse.core.rep.coref.ICoref;
import edu.mit.semantics.core.rep.archetype.ArchetypeRep;
import edu.mit.semantics.core.rep.archetype.IArchetypalReferent;
import edu.mit.semantics.ui.SemanticsUIPlugin;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class ArchetypeLabelProvider
extends StoryModelLabelProvider {
    protected Image archImg;

    public ArchetypeLabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public StyledString getStyledText(Object element) {
        Object data = element;
        long id = -1L;
        if (data instanceof IDesc) {
            IDesc desc;
            IDesc iDesc = desc = data instanceof IDesc ? (IDesc)data : null;
            if (ArchetypeRep.getInstance().isType((IHasRep)desc)) {
                id = desc.getID();
                data = desc.getData();
            }
        }
        if (data instanceof IArchetypalReferent) {
            IArchetypalReferent archetype = (IArchetypalReferent)data;
            ICoref coref = (ICoref)archetype.getActor().getData();
            StyledString result = new StyledString();
            result.append(coref.getName());
            result.append(" - ");
            result.append(archetype.getArchetype().getName(), StyledString.COUNTER_STYLER);
            ArchetypeLabelProvider.appendID((StyledString)result, (long)id);
            if (element instanceof IDesc) {
                ArchetypeLabelProvider.appendMergeTags((StyledString)result, (IDesc)((IDesc)element));
            }
            return result;
        }
        return super.getStyledText(data);
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc && ArchetypeRep.getInstance().isType((IHasRep)((IDesc)element))) {
            return this.getArchetypeImage();
        }
        return super.getImage(element);
    }

    protected Image getArchetypeImage() {
        if (this.archImg == null) {
            this.archImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/archetype.gif");
        }
        return this.archImg;
    }
}

