/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.helpers;

import edu.mit.jpropbank.Aspect;
import edu.mit.jpropbank.Feature;
import edu.mit.jpropbank.Form;
import edu.mit.jpropbank.Label;
import edu.mit.jpropbank.Tense;
import edu.mit.jpropbank.frames.IRole;
import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.parsing.core.rep.token.TokenDisplayText;
import edu.mit.parsing.ui.controllers.ISegmentSetController;
import edu.mit.parsing.ui.widgets.SegmentSetCaptureWidget;
import edu.mit.semantics.core.rep.semrole.model.ISemArgModel;
import edu.mit.semantics.core.rep.semrole.model.ISemRoleModel;
import edu.mit.semantics.core.rep.semrole.model.SemRoleModel;
import edu.mit.semantics.ui.content.LabelContentProvider;
import edu.mit.semantics.ui.content.RoleSetContentProvider;
import edu.mit.semantics.ui.content.SemRoleContentProvider;
import edu.mit.semantics.ui.controllers.ISemRoleController;
import edu.mit.semantics.ui.controllers.SemRoleController;
import edu.mit.semantics.ui.label.FeatureLabelProvider;
import edu.mit.semantics.ui.label.LabelLabelProvider;
import edu.mit.semantics.ui.label.RoleSetLabelProvider;
import edu.mit.semantics.ui.label.RolesetExampleLabelProvider;
import edu.mit.semantics.ui.label.SemRoleLabelProvider;
import edu.mit.story.core.datamodel.IViewModel;
import edu.mit.story.core.datamodel.ModelWrapper;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.util.IDescDisplayText;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.controllers.IDescController;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.items.CommandHooks;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.viewers.StyledTextViewer;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.DescCaptureWidget;
import edu.mit.story.ui.widgets.MessageBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemRoleCreatorPage
extends HelperPage
implements ICreatorPage,
IAdaptable {
    public static final String ID = SemRoleCreatorPage.class.getName();
    public static final String NONE = "(no feature)";
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String actionLabelCommit = "Commit Semantic Role";
    public static String actionLabelSave = "Save Semantic Role";
    public static String actionLabelClear = "Clear Semantic Role";
    public static String actionLabelCancel = "Cancel Editing";
    public static IMessageProvider clearedMessage = new Message("Use this page to create a new semantic role", 1);
    public static IMessageProvider createMessage = new Message("Press the 'commit' button to add this semantic role to the story model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'save' button to change this semantic role in the story model", 1);
    public static IMessageProvider addArgMessage = new Message("Press the 'add argument' button to add this argument to the semantic role", 1);
    protected ISemRoleController<ISemRoleModel> controller;
    protected MessageProviderManager messageManager;
    protected MessageBar messageBar;
    protected TreeViewer semroleViewer;
    protected StyledTextViewer exampleViewer;
    protected DescCaptureWidget<IDescController<?>> predWidget;
    protected ComboViewer rolesetCombo;
    protected Button chooseRoleSetButton;
    protected ComboViewer roleCombo;
    protected ComboViewer labelCombo;
    protected ComboViewer featureCombo;
    protected SegmentSetCaptureWidget<ISegmentSetController> argWidget;
    protected Button createArgButton;
    protected Button activeButton;
    protected Button thirdPersonButton;
    protected Combo tenseCombo;
    protected Combo aspectCombo;
    protected Combo formCombo;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction createArgAction;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;
    protected ButtonAction chooseRoleSetAction;

    public ISemRoleController<ISemRoleModel> getController() {
        return this.controller;
    }

    public void createControl(Composite parent) {
        this.controller = new SemRoleController<SemRoleModel>(new SemRoleModel((IStoryModel)this.getStoryEditor().getStoryModel()), "edu.mit.story.ui.annotation.target1", "edu.mit.story.ui.annotation.target2", this.getStoryEditor());
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)SemRoleCreatorPage.zeroMargins((GridLayout)new GridLayout(), (boolean)false, (boolean)true));
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.setControl((Control)control);
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false));
        this.messageBar.setBackground(control.getBackground());
        this.messageBar.setForeground(control.getForeground());
        org.eclipse.swt.widgets.Label rule = new org.eclipse.swt.widgets.Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false));
        SashForm sash = new SashForm(control, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite controls = new Composite((Composite)sash, 0);
        controls.setLayoutData((Object)new GridData(4, 4, true, true));
        controls.setBackground(control.getBackground());
        controls.setForeground(control.getForeground());
        controls.setLayout((Layout)new GridLayout(2, false));
        this.createPredicateControl(controls);
        this.createFeaturesControl(controls);
        this.createRolesetControl(controls);
        this.createArgumentControl(controls);
        this.createCommitControl(controls);
        SashForm viewers = new SashForm((Composite)sash, 512);
        viewers.setLayoutData((Object)new GridData(4, 4, true, true));
        viewers.setBackground(control.getBackground());
        viewers.setForeground(control.getForeground());
        sash.setWeights(new int[]{2, 1});
        this.semroleViewer = new TreeViewer((Composite)viewers, 2820);
        this.semroleViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.semroleViewer.setContentProvider((IContentProvider)new SemRoleContentProvider(this.getStoryEditor(), false));
        this.semroleViewer.setLabelProvider((IBaseLabelProvider)new SemRoleLabelProvider(this.getStoryEditor()));
        ColorManager.inheritColors((Control)this.semroleViewer.getTree());
        this.semroleViewer.setInput((Object)new ModelWrapper(new IViewModel[]{this.controller.getDescModel()}));
        CommandContributionItem editAction = CommandHooks.createEdit((IServiceLocator)this.getSite().getWorkbenchWindow());
        CommandContributionItem deleteAction = CommandHooks.createDelete((IServiceLocator)this.getSite().getWorkbenchWindow());
        MenuManager m = new MenuManager();
        m.add((IContributionItem)new Separator("group.edit"));
        m.appendToGroup("group.edit", (IContributionItem)editAction);
        m.appendToGroup("group.edit", (IContributionItem)deleteAction);
        this.semroleViewer.getTree().setMenu(m.createContextMenu((Control)this.semroleViewer.getTree()));
        this.exampleViewer = new StyledTextViewer((Composite)viewers, 2816);
        this.exampleViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ColorManager.inheritColors((Control)this.exampleViewer.getControl());
        this.exampleViewer.setLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new RolesetExampleLabelProvider());
        viewers.setWeights(new int[]{1, 1});
        this.controller.getArgController().getArgModel().setIsValidMessage(addArgMessage);
        this.messageManager = new MessageProviderManager();
        this.messageManager.setDefaultMesage(createMessage);
        this.messageManager.setAllClearedMesage(clearedMessage);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getDescModel(), true);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getArgController().getArgModel(), true);
        this.messageManager.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                SemRoleCreatorPage.this.updateFromModel();
            }
        });
        this.updateFromModel();
    }

    protected void createAnnotationControls(Composite parent) {
    }

    protected void createPredicateControl(Composite parent) {
        org.eclipse.swt.widgets.Label label = new org.eclipse.swt.widgets.Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ColorManager.inheritColors((Control)label);
        label.setText("Verb");
        this.predWidget = new DescCaptureWidget(parent, 0, this.controller, (IDescDisplayText)TokenDisplayText.getInstance());
        this.predWidget.setLayoutData((Object)new GridData(4, 4, true, false));
        this.predWidget.getCaptureAction().setText("Capture Predicate");
        this.predWidget.getCaptureAction().setToolTipText("Capture predicate from editor");
        this.predWidget.getClearAction().setText("Clear Prediate");
        this.predWidget.getClearAction().setToolTipText("Clear selected predicate");
    }

    protected void createRolesetControl(Composite parent) {
        org.eclipse.swt.widgets.Label label = new org.eclipse.swt.widgets.Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ColorManager.inheritColors((Control)label);
        label.setText("Roleset");
        Composite controls = new Composite(parent, 0);
        controls.setLayoutData((Object)new GridData(4, 4, true, false));
        ColorManager.inheritColors((Control)controls);
        controls.setLayout((Layout)SemRoleCreatorPage.zeroMargins((GridLayout)new GridLayout(3, false)));
        this.rolesetCombo = new ComboViewer(new CCombo(controls, 2056));
        ColorManager.inheritColors((Control)this.rolesetCombo.getCCombo());
        this.rolesetCombo.setContentProvider((IContentProvider)RoleSetContentProvider.getInstance());
        this.rolesetCombo.setLabelProvider((IBaseLabelProvider)RoleSetLabelProvider.getInstance());
        this.rolesetCombo.setInput((Object)((ISemRoleModel)this.getController().getDescModel()).getPossibleRoleSets());
        this.rolesetCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.rolesetCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IRoleset roleset = (IRoleset)SelectionUtils.extractSingle((ISelection)event.getSelection(), IRoleset.class);
                SemRoleCreatorPage.this.controller.setRoleSet(roleset);
            }
        });
        label = new org.eclipse.swt.widgets.Label(controls, 0);
        GridData gd = new GridData();
        gd.widthHint = 20;
        label.setLayoutData((Object)gd);
        ColorManager.inheritColors((Control)label);
        this.chooseRoleSetButton = new Button(controls, 0);
        this.chooseRoleSetButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.chooseRoleSetButton.setText("Choose Arbitrary RoleSet...");
        this.chooseRoleSetAction = new ButtonAction(this.chooseRoleSetButton){

            public void run() {
                SemRoleCreatorPage.this.controller.chooseArbitraryRoleset();
            }
        };
        this.chooseRoleSetAction.setText("Choose Arbitrary RoleSet...");
        this.chooseRoleSetAction.setToolTipText("Choose from all available RoleSets");
    }

    protected void createArgumentControl(Composite parent) {
        org.eclipse.swt.widgets.Label label = new org.eclipse.swt.widgets.Label(parent, 258);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        ColorManager.inheritColors((Control)label);
        label = new org.eclipse.swt.widgets.Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ColorManager.inheritColors((Control)label);
        label.setText("Arguments");
        this.argWidget = new SegmentSetCaptureWidget<ISegmentSetController>(parent, 0, (ISegmentSetController)this.controller.getArgController()){

            protected void createTrailingControls(Composite parent) {
                parent.setLayout((Layout)SemRoleCreatorPage.zeroMargins((GridLayout)new GridLayout()));
                SemRoleCreatorPage.this.createArgButton = new Button(parent, 0);
                SemRoleCreatorPage.this.createArgButton.setText("Create");
                SemRoleCreatorPage.this.createArgAction = new ButtonAction(SemRoleCreatorPage.this.createArgButton){

                    public void run() {
                        (this).SemRoleCreatorPage.this.controller.createArgument();
                    }
                };
                SemRoleCreatorPage.this.createArgAction.setText("Create");
                SemRoleCreatorPage.this.createArgAction.setToolTipText("Create");
            }
        };
        ColorManager.inheritColors(this.argWidget);
        this.argWidget.setLayoutData((Object)new GridData(4, 0, true, false));
        label = new org.eclipse.swt.widgets.Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ColorManager.inheritColors((Control)label);
        Composite roleCombos = new Composite(parent, 0);
        ColorManager.inheritColors((Control)roleCombos);
        GridLayout layout = new GridLayout(6, false);
        layout.marginHeight = 0;
        roleCombos.setLayout((Layout)layout);
        label = new org.eclipse.swt.widgets.Label(roleCombos, 0);
        label.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        ColorManager.inheritColors((Control)label);
        label.setText("Role");
        this.roleCombo = new ComboViewer(roleCombos, 8);
        this.roleCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.roleCombo.setLabelProvider((IBaseLabelProvider)RoleSetLabelProvider.getInstance());
        this.roleCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IRole role = (IRole)SelectionUtils.extractSingle((ISelection)event.getSelection(), IRole.class);
                if (role != null) {
                    SemRoleCreatorPage.this.controller.getArgController().setLabel(role.getLabel());
                    SemRoleCreatorPage.this.controller.getArgController().setFeature(role.getFeature());
                }
            }
        });
        Label[] labelComboInput = Label.values();
        Object[] featureComboInput = new Object[Feature.values().length + 1];
        featureComboInput[0] = NONE;
        System.arraycopy(Feature.values(), 0, featureComboInput, 1, Feature.values().length);
        label = new org.eclipse.swt.widgets.Label(roleCombos, 0);
        label.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        ColorManager.inheritColors((Control)label);
        label.setText("Label");
        this.labelCombo = new ComboViewer(roleCombos, 8);
        this.labelCombo.setContentProvider((IContentProvider)LabelContentProvider.getInstance());
        this.labelCombo.setLabelProvider((IBaseLabelProvider)LabelLabelProvider.getInstance());
        this.labelCombo.setInput((Object)labelComboInput);
        this.labelCombo.getCombo().setVisibleItemCount(labelComboInput.length);
        this.labelCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SemRoleCreatorPage.this.controller.getArgController().setLabel(event.getSelection());
            }
        });
        label = new org.eclipse.swt.widgets.Label(roleCombos, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        ColorManager.inheritColors((Control)label);
        label.setText("Feature");
        this.featureCombo = new ComboViewer(roleCombos, 0);
        this.featureCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.featureCombo.setLabelProvider((IBaseLabelProvider)FeatureLabelProvider.getInstance());
        this.featureCombo.setInput((Object)featureComboInput);
        this.featureCombo.getCombo().setVisibleItemCount(featureComboInput.length);
        this.featureCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Feature feat = (Feature)SelectionUtils.extractSingle((ISelection)event.getSelection(), Feature.class);
                if (feat != null) {
                    SemRoleCreatorPage.this.controller.getArgController().setFeature(feat.name());
                }
            }
        });
        this.featureCombo.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String feat = SemRoleCreatorPage.this.featureCombo.getCombo().getText();
                SemRoleCreatorPage.this.controller.getArgController().setFeature(feat);
            }
        });
    }

    protected void createFeaturesControl(Composite parent) {
        Tense option;
        org.eclipse.swt.widgets.Label label = new org.eclipse.swt.widgets.Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ColorManager.inheritColors((Control)label);
        Composite features = new Composite(parent, 0);
        features.setLayoutData((Object)new GridData(4, 0, true, false));
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.fill = true;
        rowLayout.marginHeight = 0;
        rowLayout.marginWidth = 0;
        features.setLayout((Layout)rowLayout);
        ColorManager.inheritColors((Control)features);
        Composite group = new Composite(features, 0);
        group.setLayout((Layout)SemRoleCreatorPage.zeroMargins((GridLayout)new GridLayout(2, false)));
        ColorManager.inheritColors((Control)group);
        label = new org.eclipse.swt.widgets.Label(group, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Tense");
        ColorManager.inheritColors((Control)label);
        this.tenseCombo = new Combo(group, 8);
        Tense[] tenseArray = Tense.values();
        int n = tenseArray.length;
        int n2 = 0;
        while (n2 < n) {
            option = tenseArray[n2];
            this.tenseCombo.add(option.getName());
            ++n2;
        }
        this.tenseCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = SemRoleCreatorPage.this.tenseCombo.getSelectionIndex();
                SemRoleCreatorPage.this.controller.setTense(idx > -1 ? Tense.values()[idx] : null);
            }
        });
        group = new Composite(features, 0);
        group.setLayout((Layout)SemRoleCreatorPage.zeroMargins((GridLayout)new GridLayout(2, false)));
        ColorManager.inheritColors((Control)group);
        label = new org.eclipse.swt.widgets.Label(group, 0);
        label.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        label.setText("Aspect");
        ColorManager.inheritColors((Control)label);
        this.aspectCombo = new Combo(group, 8);
        tenseArray = Aspect.values();
        n = tenseArray.length;
        n2 = 0;
        while (n2 < n) {
            option = tenseArray[n2];
            this.aspectCombo.add(option.getName());
            ++n2;
        }
        this.aspectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = SemRoleCreatorPage.this.aspectCombo.getSelectionIndex();
                SemRoleCreatorPage.this.controller.setAspect(idx > -1 ? Aspect.values()[idx] : null);
            }
        });
        group = new Composite(features, 0);
        group.setLayout((Layout)SemRoleCreatorPage.zeroMargins((GridLayout)new GridLayout(2, false)));
        ColorManager.inheritColors((Control)group);
        label = new org.eclipse.swt.widgets.Label(group, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Form");
        ColorManager.inheritColors((Control)label);
        this.formCombo = new Combo(group, 8);
        tenseArray = Form.values();
        n = tenseArray.length;
        n2 = 0;
        while (n2 < n) {
            option = tenseArray[n2];
            this.formCombo.add(option.getName());
            ++n2;
        }
        this.formCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = SemRoleCreatorPage.this.formCombo.getSelectionIndex();
                SemRoleCreatorPage.this.controller.setForm(idx > -1 ? Form.values()[idx] : null);
            }
        });
        group = new Composite(features, 0);
        group.setLayout((Layout)SemRoleCreatorPage.zeroMargins((GridLayout)new GridLayout()));
        ColorManager.inheritColors((Control)group);
        this.activeButton = new Button(group, 32);
        this.activeButton.setText("Active?");
        this.activeButton.setLayoutData((Object)new GridData(4, 4, true, true));
        ColorManager.inheritColors((Control)this.activeButton);
        this.activeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SemRoleCreatorPage.this.controller.setActive(SemRoleCreatorPage.this.activeButton.getSelection());
            }
        });
        group = new Composite(features, 0);
        group.setLayout((Layout)SemRoleCreatorPage.zeroMargins((GridLayout)new GridLayout()));
        ColorManager.inheritColors((Control)group);
        this.thirdPersonButton = new Button(group, 32);
        this.thirdPersonButton.setText("Third Person?");
        this.thirdPersonButton.setLayoutData((Object)new GridData(4, 4, true, true));
        ColorManager.inheritColors((Control)this.thirdPersonButton);
        this.thirdPersonButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SemRoleCreatorPage.this.controller.setThirdPerson(SemRoleCreatorPage.this.thirdPersonButton.getSelection());
            }
        });
    }

    protected void createCommitControl(Composite parent) {
        org.eclipse.swt.widgets.Label label = new org.eclipse.swt.widgets.Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Composite buttons = new Composite(parent, 0);
        ColorManager.inheritColors((Control)buttons);
        buttons.setLayout((Layout)SemRoleCreatorPage.zeroMargins((GridLayout)new GridLayout(3, false)));
        buttons.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new org.eclipse.swt.widgets.Label(buttons, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commitButton = new Button(buttons, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                SemRoleCreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(buttons, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                SemRoleCreatorPage.this.controller.clear();
            }
        };
    }

    public void setActionBars(IActionBars actionBars) {
        this.predWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        this.argWidget.getAddAction().setActionDefinitionId("edu.mit.story.ui.commands.add.2");
        actionBars.setGlobalActionHandler(this.predWidget.getCaptureAction().getActionDefinitionId(), this.predWidget.getCaptureAction());
        actionBars.setGlobalActionHandler(this.argWidget.getAddAction().getActionDefinitionId(), this.argWidget.getAddAction());
        this.argWidget.getSubtractAction().setActionDefinitionId("edu.mit.story.ui.commands.subtract.2");
        actionBars.setGlobalActionHandler(this.argWidget.getSubtractAction().getActionDefinitionId(), this.argWidget.getSubtractAction());
        this.createArgAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.2");
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        actionBars.setGlobalActionHandler(this.createArgAction.getActionDefinitionId(), (IAction)this.createArgAction);
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
        this.predWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.1");
        this.argWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.2");
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        actionBars.setGlobalActionHandler(this.predWidget.getClearAction().getActionDefinitionId(), this.predWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.argWidget.getClearAction().getActionDefinitionId(), this.argWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
    }

    protected void updateFromModel() {
        ISemRoleModel semModel = (ISemRoleModel)this.controller.getDescModel();
        ISemArgModel argModel = this.controller.getArgController().getArgModel();
        boolean enableCreateArg = argModel.getMessageType() != 3;
        boolean enableCommit = argModel.isCleared() && semModel.getMessageType() != 3;
        boolean enableClear = !semModel.isCleared() || !argModel.isCleared();
        boolean isLoaded = semModel.getLoaded() != null;
        String commitButtonLabel = isLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isLoaded ? buttonLabelCancel : buttonLabelClear;
        String commitActionLabel = isLoaded ? actionLabelSave : actionLabelCommit;
        String clearActionLabel = isLoaded ? actionLabelCancel : actionLabelClear;
        IMessageProvider defaultMsg = isLoaded ? saveMessage : createMessage;
        boolean labelChanged = false;
        if (enableCreateArg != this.createArgAction.isEnabled()) {
            this.createArgAction.setEnabled(enableCreateArg);
        }
        if (enableCommit != this.commitAction.isEnabled()) {
            this.commitAction.setEnabled(enableCommit);
        }
        if (enableClear != this.clearAction.isEnabled()) {
            this.clearAction.setEnabled(enableClear);
        }
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        this.semroleViewer.getTree().setRedraw(false);
        this.semroleViewer.refresh();
        this.semroleViewer.expandAll();
        this.semroleViewer.getTree().setRedraw(true);
        if (this.exampleViewer.getInput() != semModel.getRoleset()) {
            this.exampleViewer.setInput((Object)semModel.getRoleset());
        }
        boolean isActive = semModel.isActive();
        boolean isThirdPerson = semModel.isThirdPerson();
        Tense tense = semModel.getTense();
        Aspect aspect = semModel.getAspect();
        Form form = semModel.getForm();
        if (this.activeButton.getSelection() != isActive) {
            this.activeButton.setSelection(isActive);
        }
        if (this.thirdPersonButton.getSelection() != isThirdPerson) {
            this.thirdPersonButton.setSelection(isThirdPerson);
        }
        if (this.tenseCombo.getSelectionIndex() != tense.ordinal()) {
            this.tenseCombo.select(tense.ordinal());
        }
        if (this.aspectCombo.getSelectionIndex() != aspect.ordinal()) {
            this.aspectCombo.select(aspect.ordinal());
        }
        if (this.formCombo.getSelectionIndex() != form.ordinal()) {
            this.formCombo.select(form.ordinal());
        }
        IRoleset selRoleset = semModel.getRoleset();
        StructuredSelection rolesetSel = new StructuredSelection((Object)selRoleset);
        int visItems = semModel.getPossibleRoleSets().size();
        this.rolesetCombo.refresh();
        if (!rolesetSel.equals(this.rolesetCombo.getSelection())) {
            this.rolesetCombo.setSelection((ISelection)rolesetSel);
        }
        if (this.rolesetCombo.getCCombo().getVisibleItemCount() != visItems) {
            this.rolesetCombo.getCCombo().setVisibleItemCount(visItems);
        }
        if (this.roleCombo.getInput() != selRoleset.getRoles()) {
            this.roleCombo.setInput((Object)selRoleset.getRoles());
        }
        if (this.roleCombo.getCombo().getVisibleItemCount() != selRoleset.getRoles().size()) {
            this.roleCombo.getCombo().setVisibleItemCount(selRoleset.getRoles().size());
        }
        StructuredSelection roleSel = StructuredSelection.EMPTY;
        IRole role = argModel.getRole();
        if (role != null) {
            roleSel = new StructuredSelection((Object)role);
        }
        StructuredSelection labelSel = StructuredSelection.EMPTY;
        Label label = Label.getLabel((String)argModel.getLabel());
        if (label != null) {
            labelSel = new StructuredSelection((Object)label);
        }
        String featText = argModel.getFeature();
        StructuredSelection featureSel = null;
        Feature feature = Feature.getFeature((String)featText);
        if (feature != null) {
            featureSel = new StructuredSelection((Object)feature);
        }
        if (!this.roleCombo.getSelection().equals(roleSel)) {
            this.roleCombo.setSelection((ISelection)roleSel);
        }
        if (!this.labelCombo.getSelection().equals(labelSel)) {
            this.labelCombo.setSelection((ISelection)labelSel);
        }
        if (featureSel != null) {
            if (!this.featureCombo.getSelection().equals(featureSel)) {
                this.featureCombo.setSelection((ISelection)featureSel);
            }
        } else if (!this.featureCombo.getCombo().getText().equals(featText)) {
            this.featureCombo.getCombo().setText(featText);
        }
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionProvider.class) {
            return this.semroleViewer;
        }
        if (adapter == IPostSelectionProvider.class) {
            return this.semroleViewer;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

