/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.helpers;

import edu.mit.parsing.ui.controllers.ISegmentSetController;
import edu.mit.parsing.ui.widgets.SegmentSetCaptureWidget;
import edu.mit.semantics.core.rep.context.model.IContextRelArgModel;
import edu.mit.semantics.core.rep.context.model.IContextRelationModel;
import edu.mit.semantics.ui.content.ContextRelationContentProvider;
import edu.mit.semantics.ui.controllers.ContextRelationController;
import edu.mit.semantics.ui.controllers.IContextArgController;
import edu.mit.semantics.ui.controllers.IContextRelationController;
import edu.mit.semantics.ui.label.ContextRelTerminusDisplayText;
import edu.mit.semantics.ui.label.ContextRelationLabelProvider;
import edu.mit.story.core.datamodel.IViewModel;
import edu.mit.story.core.datamodel.ModelWrapper;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.util.IDescDisplayText;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.items.CommandHooks;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.widgets.AnnotationWidget;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.DescCaptureWidget;
import edu.mit.story.ui.widgets.MessageBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.services.IServiceLocator;

public class ContextRelationCreatorPage
extends HelperPage
implements ICreatorPage,
IAdaptable {
    public static final String ID = ContextRelationCreatorPage.class.getCanonicalName();
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String buttonLabelCommitArg = "Commit Reference";
    public static String buttonLabelSaveArg = "Save Reference";
    public static String actionLabelCommit = "Commit Referent";
    public static String actionLabelSave = "Save Referent";
    public static String actionLabelClear = "Clear Referent";
    public static String actionLabelCancel = "Cancel Edit";
    public static String actionLabelCommitArg = "Commit Reference";
    public static String actionLabelSaveArg = "Save Changes in Reference";
    public static IMessageProvider clearedMessage = new Message("Use this page to create a new relation", 1);
    public static IMessageProvider createMessage = new Message("Press the 'commit' button to add this relation to the story model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'save' button to change this relation in the story model", 1);
    public static IMessageProvider addArgMessage = new Message("Press the 'commit argument' button to add this argument to the relation", 2);
    public static IMessageProvider saveArgMessage = new Message("Press the 'save argument' button to change this argument", 2);
    protected IContextRelationController controller;
    protected MessageBar messageBar;
    protected MessageProviderManager messageManager;
    protected SegmentSetCaptureWidget<ISegmentSetController> signalWidget;
    protected DescCaptureWidget<IContextArgController> argWidget;
    protected TreeViewer relViewer;
    protected Text roleText;
    protected Button headRoleButton;
    protected Button constituentRoleButton;
    protected Button chooseRoleButton;
    protected Button addArgButton;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction headRoleAction;
    protected ButtonAction memberRoleAction;
    protected ButtonAction chooseRoleAction;
    protected ButtonAction addArgAction;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        this.controller = new ContextRelationController("edu.mit.story.ui.annotation.target1", "edu.mit.story.ui.annotation.target2", this.getStoryEditor());
        this.messageManager = new MessageProviderManager(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ContextRelationCreatorPage.this.updateFromModel();
            }
        });
        this.messageManager.setAllClearedMesage(clearedMessage);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getModel(), true);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getArgController().getDescModel(), true);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        control.setLayout((Layout)layout);
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.messageBar.setBackground(control.getBackground());
        this.messageBar.setForeground(control.getForeground());
        Label rule = new Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        SashForm sash = new SashForm(control, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite widgetParent = new Composite((Composite)sash, 0);
        widgetParent.setLayoutData((Object)new GridData(4, 128, true, false));
        widgetParent.setBackground(control.getBackground());
        widgetParent.setForeground(control.getForeground());
        widgetParent.setLayout((Layout)new GridLayout(2, false));
        this.createControlSignal(widgetParent);
        this.createControlArg(widgetParent);
        this.createControlButtons(widgetParent);
        this.relViewer = new TreeViewer((Composite)sash, 2048);
        this.relViewer.setContentProvider((IContentProvider)new ContextRelationContentProvider(this.getStoryEditor()));
        this.relViewer.setLabelProvider((IBaseLabelProvider)new ContextRelationLabelProvider(this.getStoryEditor()));
        this.relViewer.setInput((Object)new ModelWrapper(new IViewModel[]{this.controller.getModel()}));
        sash.setWeights(new int[]{3, 1});
        CommandContributionItem deleteAction = CommandHooks.createDelete((IServiceLocator)this.getSite().getWorkbenchWindow());
        CommandContributionItem editAction = CommandHooks.createEdit((IServiceLocator)this.getSite().getWorkbenchWindow());
        MenuManager manager = new MenuManager();
        ActionUtils.createPopupGroups((IMenuManager)manager);
        manager.appendToGroup("group.edit", (IContributionItem)editAction);
        manager.appendToGroup("group.edit", (IContributionItem)deleteAction);
        Tree tree = this.relViewer.getTree();
        tree.setMenu(manager.createContextMenu((Control)tree));
        this.updateFromModel();
    }

    protected void createControlSignal(Composite parent) {
        Label label = new Label(parent, 0);
        label.setBackground(parent.getBackground());
        label.setForeground(parent.getForeground());
        label.setText("Signal");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.signalWidget = new SegmentSetCaptureWidget(parent, 0, this.controller.getSignalController());
        this.signalWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.signalWidget.getAddAction().setText("Add to Signal");
        this.signalWidget.getAddAction().setToolTipText("Add to Signal");
        this.signalWidget.getSubtractAction().setText("Subtract from Signal");
        this.signalWidget.getSubtractAction().setToolTipText("Subtract from Signal");
        this.signalWidget.getClearAction().setText("Clear Signal");
        this.signalWidget.getClearAction().setToolTipText("Clear Signal");
    }

    protected void createControlArg(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Argument");
        label.setBackground(parent.getBackground());
        label.setForeground(parent.getForeground());
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.argWidget = new DescCaptureWidget<IContextArgController>(parent, 0, this.controller.getArgController(), (IDescDisplayText)ContextRelTerminusDisplayText.getInstance()){

            protected void createLeadingControls(Composite parent) {
                parent.setLayout((Layout)ContextRelationCreatorPage.zeroMargins((GridLayout)new GridLayout(4, false)));
                ContextRelationCreatorPage.this.headRoleButton = new Button(parent, 32);
                ContextRelationCreatorPage.this.headRoleButton.setText("Head?");
                ColorManager.inheritColors((Control)ContextRelationCreatorPage.this.headRoleButton);
                ContextRelationCreatorPage.this.headRoleAction = new ButtonAction(ContextRelationCreatorPage.this.headRoleButton){

                    public void run() {
                        ((IContextArgController)((AnnotationWidget)this).controller).setHeadRole((this).ContextRelationCreatorPage.this.headRoleButton.getSelection());
                    }
                };
                ContextRelationCreatorPage.this.roleText = new Text(parent, 2048);
                GridData gd = new GridData(4, 0x1000000, true, false);
                gd.widthHint = ContextRelationCreatorPage.this.roleText.getFont().getFontData()[0].getHeight() * 20;
                ContextRelationCreatorPage.this.roleText.setLayoutData((Object)gd);
                ColorManager.inheritColors((Control)ContextRelationCreatorPage.this.roleText);
                ContextRelationCreatorPage.this.roleText.setEditable(false);
                ContextRelationCreatorPage.this.chooseRoleButton = new Button(parent, 0);
                ContextRelationCreatorPage.this.chooseRoleButton.setText("Role");
                ContextRelationCreatorPage.this.chooseRoleAction = new ButtonAction(ContextRelationCreatorPage.this.chooseRoleButton){

                    public void run() {
                        ((IContextArgController)((AnnotationWidget)this).controller).chooseRole();
                    }
                };
                ContextRelationCreatorPage.this.constituentRoleButton = new Button(parent, 32);
                ContextRelationCreatorPage.this.constituentRoleButton.setText("Applies to Constituents?");
                ColorManager.inheritColors((Control)ContextRelationCreatorPage.this.constituentRoleButton);
                ContextRelationCreatorPage.this.memberRoleAction = new ButtonAction(ContextRelationCreatorPage.this.constituentRoleButton){

                    public void run() {
                        ((IContextArgController)((AnnotationWidget)this).controller).setContituentRole((this).ContextRelationCreatorPage.this.constituentRoleButton.getSelection());
                    }
                };
            }

            protected void createFollowingControls(Composite parent) {
                parent.setLayout((Layout)ContextRelationCreatorPage.zeroMargins((GridLayout)new GridLayout()));
                ContextRelationCreatorPage.this.addArgButton = new Button(parent, 0);
                ContextRelationCreatorPage.this.addArgButton.setText("Add");
                ContextRelationCreatorPage.this.addArgAction = new ButtonAction(ContextRelationCreatorPage.this.addArgButton){

                    public void run() {
                        (this).ContextRelationCreatorPage.this.controller.addArgument();
                    }
                };
            }
        };
        this.argWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.argWidget.getCaptureAction().setText("Capture Argument");
        this.argWidget.getCaptureAction().setToolTipText("Capture Argument");
        this.argWidget.getClearAction().setText("Clear Argument");
        this.argWidget.getClearAction().setToolTipText("Clear Argument");
    }

    protected void createControlButtons(Composite widgetParent) {
        Label label = new Label(widgetParent, 0);
        label.setBackground(widgetParent.getBackground());
        label.setForeground(widgetParent.getForeground());
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        Composite lowerButtons = new Composite(widgetParent, 0);
        lowerButtons.setBackground(widgetParent.getBackground());
        lowerButtons.setForeground(widgetParent.getForeground());
        lowerButtons.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        lowerButtons.setLayout((Layout)ContextRelationCreatorPage.zeroMargins((GridLayout)new GridLayout(3, false)));
        label = new Label(lowerButtons, 0);
        label.setBackground(lowerButtons.getBackground());
        label.setForeground(lowerButtons.getForeground());
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commitButton = new Button(lowerButtons, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                ContextRelationCreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(lowerButtons, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                ContextRelationCreatorPage.this.controller.clear();
            }
        };
    }

    public void setActionBars(IActionBars actionBars) {
        this.signalWidget.getAddAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        this.argWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.2");
        actionBars.setGlobalActionHandler(this.signalWidget.getAddAction().getActionDefinitionId(), this.signalWidget.getAddAction());
        actionBars.setGlobalActionHandler(this.argWidget.getCaptureAction().getActionDefinitionId(), this.argWidget.getCaptureAction());
        this.signalWidget.getSubtractAction().setActionDefinitionId("edu.mit.story.ui.commands.subtract.1");
        actionBars.setGlobalActionHandler(this.signalWidget.getSubtractAction().getActionDefinitionId(), this.signalWidget.getSubtractAction());
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        this.signalWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.1");
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
        actionBars.setGlobalActionHandler(this.signalWidget.getClearAction().getActionDefinitionId(), this.signalWidget.getClearAction());
        this.addArgAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.2");
        actionBars.setGlobalActionHandler(this.addArgAction.getActionDefinitionId(), (IAction)this.addArgAction);
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
    }

    protected void updateFromModel() {
        boolean selectMember;
        boolean selectHead;
        IMessageProvider defaultMsg;
        IContextRelationModel model = this.controller.getModel();
        IContextRelArgModel argModel = (IContextRelArgModel)this.controller.getArgController().getDescModel();
        boolean isLoaded = model.getLoaded() != null;
        IMessageProvider iMessageProvider = defaultMsg = isLoaded ? saveMessage : createMessage;
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        boolean enableAdd = !argModel.isCleared() && argModel.getMessageType() != 3;
        boolean enableCommit = !model.isCleared() && this.messageManager.getMessageType() != 3;
        boolean enableClear = !model.isCleared();
        String commitButtonLabel = isLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isLoaded ? buttonLabelCancel : buttonLabelClear;
        String commitActionLabel = isLoaded ? actionLabelSave : actionLabelCommit;
        String clearActionLabel = isLoaded ? actionLabelCancel : actionLabelClear;
        String roleStr = ContextRelationLabelProvider.getRoleName(argModel.getRole()).toString();
        if (enableCommit != this.commitButton.isEnabled()) {
            this.commitButton.setEnabled(enableCommit);
        }
        if (enableClear != this.clearButton.isEnabled()) {
            this.clearButton.setEnabled(enableClear);
        }
        if (enableAdd != this.addArgButton.isEnabled()) {
            this.addArgButton.setEnabled(enableAdd);
        }
        if (!this.roleText.getText().equals(roleStr)) {
            this.roleText.setText(roleStr.toString());
        }
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        boolean bl = selectHead = argModel.getExclusionGroup() == 1;
        if (this.headRoleButton.getSelection() != selectHead) {
            this.headRoleButton.setSelection(selectHead);
        }
        boolean bl2 = selectMember = argModel.getDepth() == 1;
        if (this.constituentRoleButton.getSelection() != selectMember) {
            this.constituentRoleButton.setSelection(selectMember);
        }
        boolean labelChanged = false;
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        this.relViewer.getTree().setRedraw(false);
        this.relViewer.refresh();
        this.relViewer.expandAll();
        this.relViewer.getTree().setRedraw(true);
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public IContextRelationController getController() {
        return this.controller;
    }

    public void dispose() {
        super.dispose();
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionProvider.class) {
            return this.relViewer;
        }
        if (adapter == IPostSelectionProvider.class) {
            return this.relViewer;
        }
        return super.getAdapter(adapter);
    }
}

