/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.editor;

import edu.mit.semantics.core.rep.timex3.ITimex3;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.ui.editor.StoryTextHover;
import java.util.Iterator;

public class Timex3TextHover
extends StoryTextHover {
    public Timex3TextHover() {
        super(Timex3Rep.getInstance());
    }

    public String getHoverInfo(IStoryModel model, int hoverOffset, IHasPosition selection) {
        if (!model.supports(Timex3Rep.getInstance())) {
            return null;
        }
        IDescSet timexDescs = model.getData().getDescriptions(Timex3Rep.getInstance()).closedSet((IHasPosition)new SimplePosition(hoverOffset, 0));
        if (timexDescs.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Time Expressions:\n");
        Iterator i = timexDescs.iterator();
        while (i.hasNext()) {
            IDesc timexDesc = (IDesc)i.next();
            ITimex3 timex = (ITimex3)timexDesc.getData();
            sb.append(timex.getExpression().getDisplayText());
            sb.append(" - ");
            sb.append(timex.getType().getName());
            sb.append(" (");
            sb.append(Long.toString(timexDesc.getID()));
            sb.append(')');
            if (!i.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

